<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Driver.
 *
 * @ORM\Entity()
 * @ORM\Table(name="driver", schema="adonis")
 */
class Driver extends IdentifiedEntity
{
    public const RS232 = "rs232";
    public const BLUETOOTH = "bluetooth";
    public const USB = "usb";

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $type;

    /**
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $timeout;

    /**
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $frameLength;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $frameStart;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $frameEnd;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $csvSeparator;

    /**
     * @var Material
     *
     * @ORM\OneToOne(targetEntity="Mobile\Measure\Entity\Variable\Material", mappedBy="driver")
     */
    private $material;

    /**
     * @var integer | null
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $baudrate;

    /**
     * @var float | null
     *
     * @ORM\Column(type="float", nullable=true)
     */
    private $stopbit;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $parity;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $flowControl;

    /**
     * @var bool | null
     *
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $push;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $request;

    /**
     * @var int | null
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $databitsFormat;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $port;

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Driver
     */
    public function setType(string $type): Driver
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return int
     */
    public function getTimeout(): int
    {
        return $this->timeout;
    }

    /**
     * @param int $timeout
     * @return Driver
     */
    public function setTimeout(int $timeout): Driver
    {
        $this->timeout = $timeout;
        return $this;
    }

    /**
     * @return int
     */
    public function getFrameLength(): int
    {
        return $this->frameLength;
    }

    /**
     * @param int $frameLength
     * @return Driver
     */
    public function setFrameLength(int $frameLength): Driver
    {
        $this->frameLength = $frameLength;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFrameStart(): ?string
    {
        return $this->frameStart;
    }

    /**
     * @param string|null $frameStart
     * @return Driver
     */
    public function setFrameStart(?string $frameStart): Driver
    {
        $this->frameStart = $frameStart;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFrameEnd(): ?string
    {
        return $this->frameEnd;
    }

    /**
     * @param string|null $frameEnd
     * @return Driver
     */
    public function setFrameEnd(?string $frameEnd): Driver
    {
        $this->frameEnd = $frameEnd;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCsvSeparator(): ?string
    {
        return $this->csvSeparator;
    }

    /**
     * @param string|null $csvSeparator
     * @return Driver
     */
    public function setCsvSeparator(?string $csvSeparator): Driver
    {
        $this->csvSeparator = $csvSeparator;
        return $this;
    }

    /**
     * @return Material
     */
    public function getMaterial(): Material
    {
        return $this->material;
    }

    /**
     * @param Material $material
     * @return Driver
     */
    public function setMaterial(Material $material): Driver
    {
        $this->material = $material;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getBaudrate(): ?int
    {
        return $this->baudrate;
    }

    /**
     * @param int|null $baudrate
     * @return Driver
     */
    public function setBaudrate(?int $baudrate): Driver
    {
        $this->baudrate = $baudrate;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getStopbit(): ?float
    {
        return $this->stopbit;
    }

    /**
     * @param float|null $stopbit
     * @return Driver
     */
    public function setStopbit(?float $stopbit): Driver
    {
        $this->stopbit = $stopbit;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getParity(): ?string
    {
        return $this->parity;
    }

    /**
     * @param string|null $parity
     * @return Driver
     */
    public function setParity(?string $parity): Driver
    {
        $this->parity = $parity;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFlowControl(): ?string
    {
        return $this->flowControl;
    }

    /**
     * @param string|null $flowControl
     * @return Driver
     */
    public function setFlowControl(?string $flowControl): Driver
    {
        $this->flowControl = $flowControl;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getPush(): ?bool
    {
        return $this->push;
    }

    /**
     * @param bool|null $push
     * @return Driver
     */
    public function setPush(?bool $push): Driver
    {
        $this->push = $push;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRequest(): ?string
    {
        return $this->request;
    }

    /**
     * @param string|null $request
     * @return Driver
     */
    public function setRequest(?string $request): Driver
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getDatabitsFormat(): ?int
    {
        return $this->databitsFormat;
    }

    /**
     * @param int|null $databitsFormat
     * @return Driver
     */
    public function setDatabitsFormat(?int $databitsFormat): Driver
    {
        $this->databitsFormat = $databitsFormat;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPort(): ?string
    {
        return $this->port;
    }

    /**
     * @param string|null $port
     * @return Driver
     */
    public function setPort(?string $port): Driver
    {
        $this->port = $port;
        return $this;
    }

}
