<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Project\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class DesktopUser.
 *
 * @ORM\Entity(repositoryClass="Mobile\Project\Repository\DesktopUserRepository")
 * @ORM\Table(name="desktop_user", schema="adonis")
 */
class DesktopUser extends IdentifiedEntity
{
    /**
     * @var DataEntryProject
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="desktopUsers")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $project;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $firstname;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $login;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $password;

    public function __construct()
    {

    }

    /**
     * @return DataEntryProject
     */
    public function getProject(): DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject $project
     * @return DesktopUser
     */
    public function setProject(DataEntryProject $project): DesktopUser
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return DesktopUser
     */
    public function setName(string $name): DesktopUser
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstname(): string
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return DesktopUser
     */
    public function setFirstname(string $firstname): DesktopUser
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return DesktopUser
     */
    public function setEmail(string $email): DesktopUser
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getLogin(): string
    {
        return $this->login;
    }

    /**
     * @param string $login
     * @return DesktopUser
     */
    public function setLogin(string $login): DesktopUser
    {
        $this->login = $login;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return DesktopUser
     */
    public function setPassword(string $password): DesktopUser
    {
        $this->password = $password;
        return $this;
    }
}
