<?php

namespace Mobile\Project\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Device\Entity\Device;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Platform.
 *
 * @ORM\Entity(repositoryClass="Mobile\Project\Repository\PlatformRepository")
 * @ORM\Table(name="platform", schema="adonis")
 */
class Platform extends IdentifiedEntity
{
    /**
     * @var DataEntryProject
     *
     * @ORM\OneToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="platform")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $project;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * @var Collection<Device>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\Device", mappedBy="platform", cascade={"persist", "remove", "detach"})
     */
    private $devices;

    /**
     * @var DateTime
     *
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $creationDate;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $site;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $place;

    /**
     * Platform constructor.
     */
    public function __construct()
    {
        $this->devices = new ArrayCollection();
    }

    /**
     * @return DataEntryProject
     */
    public function getProject(): DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject $project
     * @return Platform
     */
    public function setProject(DataEntryProject $project): Platform
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Platform
     */
    public function setName(string $name): Platform
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return Collection<Device>
     */
    public function getDevices(): Collection
    {
        return $this->devices;
    }

    /**
     * @param Device $device
     */
    public function addDevice(Device $device): void
    {
        if (!$this->devices->contains($device)) {
            $device->setPlatform($this);
            $this->devices->add($device);
        }
    }

    /**
     * @param Device $device
     */
    public function removeDevice(Device $device): void
    {
        if ($this->devices->contains($device)) {
            $this->devices->removeElement($device);
        }
    }

    /**
     * @return DateTime
     */
    public function getCreationDate(): DateTime
    {
        return $this->creationDate;
    }

    /**
     * @param DateTime $creationDate
     * @return Platform
     */
    public function setCreationDate(DateTime $creationDate): Platform
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getSite(): string
    {
        return $this->site;
    }

    /**
     * @param string $site
     * @return Platform
     */
    public function setSite(string $site): Platform
    {
        $this->site = $site;
        return $this;
    }

    /**
     * @return string
     */
    public function getPlace(): string
    {
        return $this->place;
    }

    /**
     * @param string $place
     * @return Platform
     */
    public function setPlace(string $place): Platform
    {
        $this->place = $place;
        return $this;
    }

}
