<?php

namespace Shared\Authentication\Entity;

use Doctrine\ORM\Mapping as ORM;
use ReflectionClass;
use ReflectionException;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class IdentifiedEntity.
 *
 * @ORM\MappedSuperclass()
 */
abstract class IdentifiedEntity
{
    /**
     * @Groups({"id_read"})
     *
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(name="id", type="integer")
     */
    protected $id;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     * @throws ReflectionException
     */
    public function getUri(): string
    {
        $className = (new ReflectionClass(get_class($this)))->getShortName();
        return sprintf('/%s.%d', $className, $this->id);
    }
}
