<?php


namespace Webapp\Core\Dto\Protocol;

class ProtocolInputFactorDto
{
    /**
     * @var string
     */
    private string $name;

    /**
     * @var ProtocolInputModalityDto[]
     */
    private array $modalities;

    /**
     * @var int
     */
    private int $order;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ProtocolInputFactorDto
     */
    public function setName(string $name): ProtocolInputFactorDto
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return ProtocolInputModalityDto[]
     */
    public function getModalities(): array
    {
        return $this->modalities;
    }

    /**
     * @param ProtocolInputModalityDto[] $modalities
     * @return ProtocolInputFactorDto
     */
    public function setModalities(array $modalities): ProtocolInputFactorDto
    {
        $this->modalities = $modalities;
        return $this;
    }

    /**
     * @return int
     */
    public function getOrder(): int
    {
        return $this->order;
    }

    /**
     * @param int $order
     * @return ProtocolInputFactorDto
     */
    public function setOrder(int $order): ProtocolInputFactorDto
    {
        $this->order = $order;
        return $this;
    }

}
