<?php


namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class AlgorithmCondition
 * @package Webapp\Core\Entity
 *
 * @ORM\Entity
 * @ORM\Table(name="algorithm_condition", schema="webapp")
 */
class AlgorithmCondition extends IdentifiedEntity
{
    public const CONDITION_MIN_2_FACTORS = "min2Factors";
    public const CONDITION_CONSTANT_REPETITION_NUMBER = "constantRepNumber";
    public const CONDITION_REPETITION_EQUALS_TREATMENTS = "repEqTreatments";

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"platform_full_view", "protocol_full_view"})
     */
    private ?string $type;

    /**
     * @var Algorithm
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Algorithm", inversedBy="algorithmConditions")
     */
    private Algorithm $algorithm;

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return AlgorithmCondition
     */
    public function setType(?string $type): AlgorithmCondition
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return Algorithm
     */
    public function getAlgorithm(): Algorithm
    {
        return $this->algorithm;
    }

    /**
     * @param Algorithm $algorithm
     * @return AlgorithmCondition
     */
    public function setAlgorithm(Algorithm $algorithm): AlgorithmCondition
    {
        $this->algorithm = $algorithm;
        return $this;
    }

}
