<?php

namespace Webapp\Core\Entity\Attachment;



use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\ORM\Mapping as ORM;
use Shared\Application\Entity\File;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\RightManagement\Annotation\AdvancedRight;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Entity\Platform;

/**
 * Class Factor
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     normalizationContext={
 *         "groups"={"attachment_read", "id_read"}
 *     },
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *         "post"={
 *              "security_post_denormalize"="is_granted('ROLE_PLATFORM_MANAGER')"
 *          },
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *          "delete"={
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')"
 *          },
 *     }
 *
 * )
 * @ApiFilter(SearchFilter::class, properties={"platform": "exact"})
 *
 * @AdvancedRight(parentFields={"platform"})
 *
 * @ORM\Entity()
 * @ORM\Table(name="attachment_platform", schema="webapp")
 */
class PlatformAttachment extends IdentifiedEntity
{
    /**
     * @var Platform
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Platform", inversedBy="platformAttachments")
     */
    private Platform $platform;

    /**
     * @var File
     * @ORM\OneToOne(targetEntity="Shared\Application\Entity\File", cascade={"persist", "remove"})
     * @Groups({"attachment_read", "platform_post"})
     */
    private File $file;

    /**
     * @return Platform
     */
    public function getPlatform(): Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform $platform
     * @return PlatformAttachment
     */
    public function setPlatform(Platform $platform): PlatformAttachment
    {
        $this->platform = $platform;
        return $this;
    }

    /**
     * @return File
     */
    public function getFile(): File
    {
        return $this->file;
    }

    /**
     * @param File $file
     * @return PlatformAttachment
     */
    public function setFile(File $file): PlatformAttachment
    {
        $this->file = $file;
        return $this;
    }

}
