<?php

namespace Webapp\Core\Entity\CloneProject;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\CloneProjectOperation;
use Webapp\Core\Entity\Platform;
use Webapp\Core\Entity\Project;

/**
 * Class CloneProject.
 *
 * @ApiResource(
 *     collectionOperations={
 *          "post"={
 *              "controller"=CloneProjectOperation::class,
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Clone a data entry project",
 *                  "description": "Create a copy of the given project giving him a new name"
 *              },
 *          },
 *     },
 *     itemOperations={
 *     "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }}
 * )
 *
 */
class CloneProject
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var Project
     */
    private Project $project;

    /**
     * @var string
     */
    private string $newName;

    /**
     * @var Project
     */
    private Project $result;

    /**
     * @var Platform
     */
    private Platform $platform;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return CloneProject
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Project
     */
    public function getProject(): Project
    {
        return $this->project;
    }

    /**
     * @param Project $project
     * @return CloneProject
     */
    public function setProject(Project $project): CloneProject
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return string
     */
    public function getNewName(): string
    {
        return $this->newName;
    }

    /**
     * @param string $newName
     * @return CloneProject
     */
    public function setNewName(string $newName): CloneProject
    {
        $this->newName = $newName;
        return $this;
    }

    /**
     * @return Project
     */
    public function getResult(): Project
    {
        return $this->result;
    }

    /**
     * @param Project $result
     * @return CloneProject
     */
    public function setResult(Project $result): CloneProject
    {
        $this->result = $result;
        return $this;
    }

    /**
     * @return Platform
     */
    public function getPlatform(): Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform $platform
     * @return CloneProject
     */
    public function setPlatform(Platform $platform): CloneProject
    {
        $this->platform = $platform;
        return $this;
    }
}
