<?php

namespace Webapp\Core\Entity\CloneSite;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\Site;
use Shared\Authentication\Entity\User;
use Shared\FileManagement\Entity\UserLinkedJob;
use Webapp\Core\ApiOperation\CloneSiteOperation;

/**
 * Class CloneSite.
 *
 * @ApiResource(
 *     collectionOperations={
 *          "post"={
 *              "controller"=CloneSiteOperation::class,
 *              "security"="is_granted('ROLE_SITE_ADMIN')",
 *              "openapi_context"={
 *                  "summary": "Clone a site",
 *                  "description": "Create a copy of the given site giving him a new name and wich obects to duplicate"
 *              },
 *          },
 *     },
 *     itemOperations={
 *         "get"={ "is_granted('ROLE_USER') && security"="object.getUser() == user" },
 *         "put"={ "is_granted('ROLE_USER') && security"="object.getUser() == user" },
 *         "delete" = { "security"= "is_granted('ROLE_USER') && object.getUser() == user" }
 *     }
 * )
 * @ORM\Entity
 * @ORM\Table(name="clone_site", schema="webapp")
 *
 */
class CloneSite extends UserLinkedJob
{
    /**
     * @var Site
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\Site")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private Site $originSite;

    /**
     * @var string
     * @ORM\Column(type="string")
     */
    private string $name;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $cloneLibraries;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $cloneUsers;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $clonePlatforms;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $cloneProjects;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $cloneEntries;

    /**
     * @var Site|null
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\Site", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="CASCADE")
     */
    private ?Site $result;

    /**
     * @var User|null
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\User", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="CASCADE")
     */
    private ?User $admin;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return CloneSite
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Site
     */
    public function getOriginSite(): Site
    {
        return $this->originSite;
    }

    /**
     * @param Site $originSite
     * @return CloneSite
     */
    public function setOriginSite(Site $originSite): CloneSite
    {
        $this->originSite = $originSite;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return CloneSite
     */
    public function setName(string $name): CloneSite
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCloneLibraries(): bool
    {
        return $this->cloneLibraries;
    }

    /**
     * @param bool $cloneLibraries
     * @return CloneSite
     */
    public function setCloneLibraries(bool $cloneLibraries): CloneSite
    {
        $this->cloneLibraries = $cloneLibraries;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCloneUsers(): bool
    {
        return $this->cloneUsers;
    }

    /**
     * @param bool $cloneUsers
     * @return CloneSite
     */
    public function setCloneUsers(bool $cloneUsers): CloneSite
    {
        $this->cloneUsers = $cloneUsers;
        return $this;
    }

    /**
     * @return bool
     */
    public function isClonePlatforms(): bool
    {
        return $this->clonePlatforms;
    }

    /**
     * @param bool $clonePlatforms
     * @return CloneSite
     */
    public function setClonePlatforms(bool $clonePlatforms): CloneSite
    {
        $this->clonePlatforms = $clonePlatforms;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCloneProjects(): bool
    {
        return $this->cloneProjects;
    }

    /**
     * @param bool $cloneProjects
     * @return CloneSite
     */
    public function setCloneProjects(bool $cloneProjects): CloneSite
    {
        $this->cloneProjects = $cloneProjects;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCloneEntries(): bool
    {
        return $this->cloneEntries;
    }

    /**
     * @param bool $cloneEntries
     * @return CloneSite
     */
    public function setCloneEntries(bool $cloneEntries): CloneSite
    {
        $this->cloneEntries = $cloneEntries;
        return $this;
    }

    /**
     * @return Site|null
     */
    public function getResult(): ?Site
    {
        return $this->result;
    }

    /**
     * @param Site|null $result
     * @return CloneSite
     */
    public function setResult(?Site $result): CloneSite
    {
        $this->result = $result;
        return $this;
    }

    /**
     * @return User|null
     */
    public function getAdmin(): ?User
    {
        return $this->admin;
    }

    /**
     * @param User|null $admin
     */
    public function setAdmin(?User $admin): void
    {
        $this->admin = $admin;
    }

}
