<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\DeleteBusinessObjectOperation;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "delete"={
 *              "controller"=DeleteBusinessObjectOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Delete one or more buisness object given in parameter",
 *                  "description": "Delete all items with given IRI"
 *              }
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class Delete
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var array<array<string>>
     */
    private array $objectIris;

    public function __construct()
    {
        $this->objectIris = [];
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return Delete
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return \string[][]
     */
    public function getObjectIris(): array
    {
        return $this->objectIris;
    }

    /**
     * @param \string[][] $objectIris
     * @return Delete
     */
    public function setObjectIris(array $objectIris): Delete
    {
        $this->objectIris = $objectIris;
        return $this;
    }

}
