<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\RightManagement\Annotation\AdvancedRight;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class NorthIndicatorGraphic
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={}
 *     },
 *     itemOperations={
 *          "get"={},
 *          "delete"={},
 *          "patch"={}
 *     }
 * )
 * @AdvancedRight(parentFields={"platform"})
 *
 * @ORM\Entity
 * @ORM\Table(name="north_indicator", schema="webapp")
 */
class NorthIndicator extends IdentifiedEntity
{
    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $orientation;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $x;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $y;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $width;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $height;

    /**
     * @var Platform
     *
     * @ORM\OneToOne(targetEntity="Webapp\Core\Entity\Platform", inversedBy="northIndicator")
     * @ORM\JoinColumn(nullable=false)
     */
    private Platform $platform;

    /**
     * @return int
     */
    public function getOrientation(): int
    {
        return $this->orientation;
    }

    /**
     * @param int $orientation
     * @return NorthIndicator
     */
    public function setOrientation(int $orientation): NorthIndicator
    {
        $this->orientation = $orientation;
        return $this;
    }

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return NorthIndicator
     */
    public function setX(int $x): NorthIndicator
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return NorthIndicator
     */
    public function setY(int $y): NorthIndicator
    {
        $this->y = $y;
        return $this;
    }

    /**
     * @return int
     */
    public function getWidth(): int
    {
        return $this->width;
    }

    /**
     * @param int $width
     * @return NorthIndicator
     */
    public function setWidth(int $width): NorthIndicator
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return int
     */
    public function getHeight(): int
    {
        return $this->height;
    }

    /**
     * @param int $height
     * @return NorthIndicator
     */
    public function setHeight(int $height): NorthIndicator
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @return Platform
     */
    public function getPlatform(): Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform $platform
     * @return NorthIndicator
     */
    public function setPlatform(Platform $platform): NorthIndicator
    {
        $this->platform = $platform;
        return $this;
    }

}
