<?php

namespace Webapp\FileManagement\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Project\Entity\DataEntryProject;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\FileManagement\Entity\Base\UserLinkedFileJob;

/**
 * Class ResponseFile.
 *
 * @ApiResource(
 *     normalizationContext={
 *         "groups"={"response_file_read", "user_linked_file_job_read", "id_read"}
 *     },
 *     collectionOperations={
 *         "get" = {
 *         }
 *     },
 *     itemOperations={
 *         "get" = {
 *             "security"= "is_granted('ROLE_USER') && object.getUser() == user"
 *         },
 *         "delete" = {
 *             "security"= "is_granted('ROLE_USER') && object.getUser() == user"
 *         }
 *     },
 *     attributes={
 *          "order"={"id": "DESC"},
 *          "security"="is_granted('ROLE_USER')"
 *     }
 * )
 *
 * @ORM\Entity(repositoryClass="Webapp\FileManagement\Repository\ResponseFileRepository")
 * @ORM\Table(name="file_response", schema="webapp")
 *
 */
class ResponseFile extends UserLinkedFileJob
{
    /**
     * @var string
     *
     * @Groups({"response_file_read"})
     *
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @var DataEntryProject | null
     *
     * @ORM\OneToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="responseFile")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $project;

    /**
     * @return DataEntryProject | null
     */
    public function getProject(): ?DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject | null $project
     * @return ResponseFile
     */
    public function setProject(?DataEntryProject $project): ResponseFile
    {
        $this->project = $project;
        return $this;
    }
}
