<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Device\Dto;

use DateTime;

/**
 * Class UnitParcelInput.
 */
class UnitParcelInput extends PositionableInput
{
    /**
     * @var IndividualInput[]
     */
    private $individuals;

    /**
     * @var string|null
     */
    private $treatmentName;

    /**
     * @var OutExperimentationZoneInput[]
     */
    private $outExperimentationZones;

    /**
     * @var DateTime
     */
    private $aparitionDate;
    /**
     * @var DateTime|null
     */
    private $demiseDate;

    /**
     * @return IndividualInput[]
     */
    public function getIndividuals(): array
    {
        return $this->individuals;
    }

    /**
     * @param IndividualInput[] $individuals
     * @return UnitParcelInput
     */
    public function setIndividuals(array $individuals): UnitParcelInput
    {
        $this->individuals = $individuals;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTreatmentName(): ?string
    {
        return $this->treatmentName;
    }

    /**
     * @param string|null $treatmentName
     * @return UnitParcelInput
     */
    public function setTreatmentName(?string $treatmentName): UnitParcelInput
    {
        $this->treatmentName = $treatmentName;
        return $this;
    }
    /**
     * @return OutExperimentationZoneInput[]
     */
    public function getOutExperimentationZones(): array
    {
        return $this->outExperimentationZones;
    }

    /**
     * @param OutExperimentationZoneInput[] $outExperimentationZones
     * @return UnitParcelInput
     */
    public function setOutExperimentationZones(array $outExperimentationZones): UnitParcelInput
    {
        $this->outExperimentationZones = $outExperimentationZones;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getAparitionDate(): DateTime
    {
        return $this->aparitionDate;
    }

    /**
     * @param ?DateTime $aparitionDate
     * @return UnitParcelInput
     */
    public function setAparitionDate(?DateTime $aparitionDate): UnitParcelInput
    {
        $this->aparitionDate = $aparitionDate;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDemiseDate(): ?DateTime
    {
        return $this->demiseDate;
    }

    /**
     * @param DateTime|null $demiseDate
     * @return UnitParcelInput
     */
    public function setDemiseDate(?DateTime $demiseDate): UnitParcelInput
    {
        $this->demiseDate = $demiseDate;
        return $this;
    }

}
