<?php

namespace Mobile\Measure\Entity\Test;

use Mobile\Measure\Entity\Test\Base\Test;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class RangeTest.
 *
 * @ORM\Entity()
 * @ORM\Table(name="test_range", schema="adonis")
 */
class RangeTest extends Test
{
    const RANGE_TEST = 'RangeTest';

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="rangeTests")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    protected $variable;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $mandatoryMinValue;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $mandatoryMaxValue;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $optionalMinValue;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $optionalMaxValue;

    /**
     * @return string
     */
    public function getTypeTest(): string
    {
        return static::RANGE_TEST;
    }

    /**
     * @return float
     */
    public function getMandatoryMinValue(): float
    {
        return $this->mandatoryMinValue;
    }

    /**
     * @param float $mandatoryMinValue
     * @return RangeTest
     */
    public function setMandatoryMinValue(float $mandatoryMinValue): RangeTest
    {
        $this->mandatoryMinValue = $mandatoryMinValue;
        return $this;
    }

    /**
     * @return float
     */
    public function getMandatoryMaxValue(): float
    {
        return $this->mandatoryMaxValue;
    }

    /**
     * @param float $mandatoryMaxValue
     * @return RangeTest
     */
    public function setMandatoryMaxValue(float $mandatoryMaxValue): RangeTest
    {
        $this->mandatoryMaxValue = $mandatoryMaxValue;
        return $this;
    }

    /**
     * @return float
     */
    public function getOptionalMinValue(): float
    {
        return $this->optionalMinValue;
    }

    /**
     * @param float $optionalMinValue
     * @return RangeTest
     */
    public function setOptionalMinValue(float $optionalMinValue): RangeTest
    {
        $this->optionalMinValue = $optionalMinValue;
        return $this;
    }

    /**
     * @return float
     */
    public function getOptionalMaxValue(): float
    {
        return $this->optionalMaxValue;
    }

    /**
     * @param float $optionalMaxValue
     * @return RangeTest
     */
    public function setOptionalMaxValue(float $optionalMaxValue): RangeTest
    {
        $this->optionalMaxValue = $optionalMaxValue;
        return $this;
    }
}
