<?php


namespace Shared\RightManagement\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class AdvancedGroupRight
 * @package Shared\RightManagement\Entity
 *
 * @ORM\MappedSuperclass
 */
class AbstractAdvancedRight
{
    public const ADVANCED_RIGHT_EDIT="edit";
    public const ADVANCED_RIGHT_VIEW="view";

    /**
     * @var string
     * @ORM\Column(name="class_identifier", type="string")
     * @ORM\Id
     */
    private string $classIdentifier;
    /**
     * @var int
     * @ORM\Column(name="object_id", type="integer")
     * @ORM\Id
     */
    private int $objectId;

    /**
     * @var string
     * @ORM\Column(name="ad_right", type="string")
     */
    private string $right;

    /**
     * @return string
     */
    public function getClassIdentifier(): string
    {
        return $this->classIdentifier;
    }

    /**
     * @param string $classIdentifier
     * @return AbstractAdvancedRight
     */
    public function setClassIdentifier(string $classIdentifier): AbstractAdvancedRight
    {
        $this->classIdentifier = $classIdentifier;
        return $this;
    }

    /**
     * @return int
     */
    public function getObjectId(): int
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     * @return AbstractAdvancedRight
     */
    public function setObjectId(int $objectId): AbstractAdvancedRight
    {
        $this->objectId = $objectId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRight(): string
    {
        return $this->right;
    }

    /**
     * @param string $right
     * @return AbstractAdvancedRight
     */
    public function setRight(string $right): AbstractAdvancedRight
    {
        $this->right = $right;
        return $this;
    }
}
