<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\Site;

/**
 * Class GraphicalConfiguration
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *         "post"={
 *              "security_post_denormalize"="is_granted('ROLE_PLATFORM_MANAGER', object.getSite())",
 *          }
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *         "patch"={
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER', object.getSite())",
 *          },
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={"site": "exact"})
 *
 * @ORM\Entity
 * @ORM\Table(name="graphical_configuration", schema="webapp")
 */
class GraphicalConfiguration extends IdentifiedEntity
{
    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $individualColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $unitPlotColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $blockColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $subBlockColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $experimentColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $platformColor;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $selectedItemColor;

    /**
     * @var Site
     * @ORM\OneToOne(targetEntity="Shared\Authentication\Entity\Site", inversedBy="graphicalConfiguration")
     * @ORM\JoinColumn(nullable=false)
     */
    private Site $site;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $experimentLabels;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $blocLabels;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $subBlocLabels;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $unitPlotLabels;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $surfacicUnitPlotLabels;

    /**
     * @var array|null
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private ?array $individualLabels;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private bool $activeBreadcrumb;

    public function __construct($site)
    {
        $this->site = $site;
        $this->individualColor = null;
        $this->unitPlotColor = null;
        $this->blockColor = null;
        $this->subBlockColor = null;
        $this->experimentColor = null;
        $this->platformColor = null;
        $this->selectedItemColor = null;
        $this->experimentLabels = null;
        $this->blocLabels = null;
        $this->subBlocLabels = null;
        $this->unitPlotLabels = null;
        $this->surfacicUnitPlotLabels = null;
        $this->individualLabels = null;
        $this->activeBreadcrumb = true;
    }

    /**
     * @return int|null
     */
    public function getIndividualColor(): ?int
    {
        return $this->individualColor;
    }

    /**
     * @param int|null $individualColor
     * @return GraphicalConfiguration
     */
    public function setIndividualColor(?int $individualColor): GraphicalConfiguration
    {
        $this->individualColor = $individualColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getUnitPlotColor(): ?int
    {
        return $this->unitPlotColor;
    }

    /**
     * @param int|null $unitPlotColor
     * @return GraphicalConfiguration
     */
    public function setUnitPlotColor(?int $unitPlotColor): GraphicalConfiguration
    {
        $this->unitPlotColor = $unitPlotColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getBlockColor(): ?int
    {
        return $this->blockColor;
    }

    /**
     * @param int|null $blockColor
     * @return GraphicalConfiguration
     */
    public function setBlockColor(?int $blockColor): GraphicalConfiguration
    {
        $this->blockColor = $blockColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSubBlockColor(): ?int
    {
        return $this->subBlockColor;
    }

    /**
     * @param int|null $subBlockColor
     * @return GraphicalConfiguration
     */
    public function setSubBlockColor(?int $subBlockColor): GraphicalConfiguration
    {
        $this->subBlockColor = $subBlockColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getExperimentColor(): ?int
    {
        return $this->experimentColor;
    }

    /**
     * @param int|null $experimentColor
     * @return GraphicalConfiguration
     */
    public function setExperimentColor(?int $experimentColor): GraphicalConfiguration
    {
        $this->experimentColor = $experimentColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPlatformColor(): ?int
    {
        return $this->platformColor;
    }

    /**
     * @param int|null $platformColor
     * @return GraphicalConfiguration
     */
    public function setPlatformColor(?int $platformColor): GraphicalConfiguration
    {
        $this->platformColor = $platformColor;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSelectedItemColor(): ?int
    {
        return $this->selectedItemColor;
    }

    /**
     * @param int|null $selectedItemColor
     * @return GraphicalConfiguration
     */
    public function setSelectedItemColor(?int $selectedItemColor): GraphicalConfiguration
    {
        $this->selectedItemColor = $selectedItemColor;
        return $this;
    }

    /**
     * @return Site
     */
    public function getSite(): Site
    {
        return $this->site;
    }

    /**
     * @param Site $site
     * @return GraphicalConfiguration
     */
    public function setSite(Site $site): GraphicalConfiguration
    {
        $this->site = $site;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getExperimentLabels(): ?array
    {
        return $this->experimentLabels;
    }

    /**
     * @param array|null $experimentLabels
     * @return GraphicalConfiguration
     */
    public function setExperimentLabels(?array $experimentLabels): GraphicalConfiguration
    {
        $this->experimentLabels = $experimentLabels;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getBlocLabels(): ?array
    {
        return $this->blocLabels;
    }

    /**
     * @param array|null $blocLabels
     * @return GraphicalConfiguration
     */
    public function setBlocLabels(?array $blocLabels): GraphicalConfiguration
    {
        $this->blocLabels = $blocLabels;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getSubBlocLabels(): ?array
    {
        return $this->subBlocLabels;
    }

    /**
     * @param array|null $subBlocLabels
     * @return GraphicalConfiguration
     */
    public function setSubBlocLabels(?array $subBlocLabels): GraphicalConfiguration
    {
        $this->subBlocLabels = $subBlocLabels;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getUnitPlotLabels(): ?array
    {
        return $this->unitPlotLabels;
    }

    /**
     * @param array|null $unitPlotLabels
     * @return GraphicalConfiguration
     */
    public function setUnitPlotLabels(?array $unitPlotLabels): GraphicalConfiguration
    {
        $this->unitPlotLabels = $unitPlotLabels;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getSurfacicUnitPlotLabels(): ?array
    {
        return $this->surfacicUnitPlotLabels;
    }

    /**
     * @param array|null $surfacicUnitPlotLabels
     * @return GraphicalConfiguration
     */
    public function setSurfacicUnitPlotLabels(?array $surfacicUnitPlotLabels): GraphicalConfiguration
    {
        $this->surfacicUnitPlotLabels = $surfacicUnitPlotLabels;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getIndividualLabels(): ?array
    {
        return $this->individualLabels;
    }

    /**
     * @param array|null $individualLabels
     * @return GraphicalConfiguration
     */
    public function setIndividualLabels(?array $individualLabels): GraphicalConfiguration
    {
        $this->individualLabels = $individualLabels;
        return $this;
    }

    /**
     * @return bool
     */
    public function isActiveBreadcrumb(): bool
    {
        return $this->activeBreadcrumb;
    }

    /**
     * @param bool $activeBreadcrumb
     * @return GraphicalConfiguration
     */
    public function setActiveBreadcrumb(bool $activeBreadcrumb): GraphicalConfiguration
    {
        $this->activeBreadcrumb = $activeBreadcrumb;
        return $this;
    }
}
