<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\RightManagement\Annotation\AdvancedRight;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class GraphicalTextZone
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={}
 *     },
 *     itemOperations={
 *          "get"={},
 *          "delete"={},
 *          "patch"={}
 *     }
 * )
 * @ApiFilter(SearchFilter::class, properties={"platform": "exact"})
 * @AdvancedRight(parentFields={"platform"})
 *
 * @ORM\Entity
 * @ORM\Table(name="graphical_text_zone", schema="webapp")
 */
class GraphicalTextZone extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="text")
     * @Groups({"platform_full_view"})
     */
    private string $text;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"platform_full_view"})
     */
    private ?int $color;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $x;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $y;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $width;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $height;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $size;

    /**
     * @var Platform
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Platform", inversedBy="graphicalTextZones")
     * @ORM\JoinColumn(nullable=false)
     */
    private Platform $platform;

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return GraphicalTextZone
     */
    public function setText(string $text): GraphicalTextZone
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getColor(): ?int
    {
        return $this->color;
    }

    /**
     * @param int|null $color
     * @return GraphicalTextZone
     */
    public function setColor(?int $color): GraphicalTextZone
    {
        $this->color = $color;
        return $this;
    }

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return GraphicalTextZone
     */
    public function setX(int $x): GraphicalTextZone
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return GraphicalTextZone
     */
    public function setY(int $y): GraphicalTextZone
    {
        $this->y = $y;
        return $this;
    }

    /**
     * @return int
     */
    public function getWidth(): int
    {
        return $this->width;
    }

    /**
     * @param int $width
     * @return GraphicalTextZone
     */
    public function setWidth(int $width): GraphicalTextZone
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return int
     */
    public function getHeight(): int
    {
        return $this->height;
    }

    /**
     * @param int $height
     * @return GraphicalTextZone
     */
    public function setHeight(int $height): GraphicalTextZone
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @return int
     */
    public function getSize(): int
    {
        return $this->size;
    }

    /**
     * @param int $size
     * @return GraphicalTextZone
     */
    public function setSize(int $size): GraphicalTextZone
    {
        $this->size = $size;
        return $this;
    }

    /**
     * @return Platform
     */
    public function getPlatform(): Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform $platform
     * @return GraphicalTextZone
     */
    public function setPlatform(Platform $platform): GraphicalTextZone
    {
        $this->platform = $platform;
        return $this;
    }
}
