<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\GroupFilter;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\SoftDeleteable\Traits\SoftDeleteableEntity;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Annotation\GraphicallyDeletable;
use Webapp\Core\Traits\GraphicallyDeletableEntity;

/**
 * Class OutExperimentationZone
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     normalizationContext={
 *         "groups"={"platform_full_view", "id_read"}
 *     },
 *     collectionOperations={
 *          "get"={}
 *     },
 *     itemOperations={
 *          "get"={},
 *          "patch"={
 *              "denormalization_context"={"groups"={"oez_edit"}}
 *          }
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={"experiment": "exact", "block": "exact", "subBlock": "exact", "unitPlot": "exact"})
 * @ApiFilter(GroupFilter::class, arguments={"whitelist"={"design_explorer_view", "platform_full_view", "parent_view"}})
 *
 * @Gedmo\SoftDeleteable()
 * @GraphicallyDeletable()
 *
 * @ORM\Entity()
 * @ORM\Table(name="out_experimentation_zone", schema="webapp")
 */
class OutExperimentationZone extends IdentifiedEntity implements BusinessObject
{
    use GraphicallyDeletableEntity;

    use SoftDeleteableEntity;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     * @Groups({"design_explorer_view", "platform_full_view", "webapp_data_view"})
     */
    private string $number;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"design_explorer_view", "platform_full_view", "webapp_data_view"})
     */
    private int $x;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"design_explorer_view", "platform_full_view", "webapp_data_view"})
     */
    private int $y;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"design_explorer_view", "platform_full_view", "webapp_data_view", "oez_edit"})
     */
    private ?string $comment;

    /**
     * @var OezNature
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\OezNature", inversedBy="outExperimentationZones")
     * @ORM\JoinColumn(nullable=false)
     * @Groups({"platform_full_view", "design_explorer_view"})
     */
    private OezNature $nature;

    /**
     * @var ?UnitPlot
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\UnitPlot", inversedBy="outExperimentationZones")
     * @Groups({"webapp_data_view", "parent_view"})
     */
    private ?UnitPlot $unitPlot;

    /**
     * @var ?SubBlock
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SubBlock", inversedBy="outExperimentationZones")
     * @Groups({"webapp_data_view", "parent_view"})
     */
    private ?SubBlock $subBlock;

    /**
     * @var ?Block
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Block", inversedBy="outExperimentationZones")
     * @Groups({"webapp_data_view", "parent_view"})
     */
    private ?Block $block;

    /**
     * @var ?Experiment
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Experiment", inversedBy="outExperimentationZones")
     * @Groups({"webapp_data_view", "parent_view"})
     */
    private ?Experiment $experiment;

    /**
     * @var int|null
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"platform_full_view"})
     */
    private ?int $color;

    public function __construct()
    {
        $this->comment = null;
        $this->experiment = null;
        $this->block = null;
        $this->subBlock = null;
        $this->unitPlot = null;
    }

    /**
     * @Groups({"platform_full_view"})
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getNumber(): string
    {
        return $this->number;
    }

    /**
     * @param string $number
     * @return OutExperimentationZone
     */
    public function setNumber(string $number): OutExperimentationZone
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return OutExperimentationZone
     */
    public function setX(int $x): OutExperimentationZone
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return OutExperimentationZone
     */
    public function setY(int $y): OutExperimentationZone
    {
        $this->y = $y;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return OutExperimentationZone
     */
    public function setComment(?string $comment): OutExperimentationZone
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return UnitPlot|null
     */
    public function getUnitPlot(): ?UnitPlot
    {
        return $this->unitPlot;
    }

    /**
     * @param UnitPlot|null $unitPlot
     * @return OutExperimentationZone
     */
    public function setUnitPlot(?UnitPlot $unitPlot): OutExperimentationZone
    {
        $this->unitPlot = $unitPlot;
        return $this;
    }

    /**
     * @return SubBlock|null
     */
    public function getSubBlock(): ?SubBlock
    {
        return $this->subBlock;
    }

    /**
     * @param SubBlock|null $subBlock
     * @return OutExperimentationZone
     */
    public function setSubBlock(?SubBlock $subBlock): OutExperimentationZone
    {
        $this->subBlock = $subBlock;
        return $this;
    }

    /**
     * @return Block|null
     */
    public function getBlock(): ?Block
    {
        return $this->block;
    }

    /**
     * @param Block|null $block
     * @return OutExperimentationZone
     */
    public function setBlock(?Block $block): OutExperimentationZone
    {
        $this->block = $block;
        return $this;
    }

    /**
     * @return Experiment|null
     */
    public function getExperiment(): ?Experiment
    {
        return $this->experiment;
    }

    /**
     * @return OezNature
     */
    public function getNature(): OezNature
    {
        return $this->nature;
    }

    /**
     * @param OezNature $nature
     * @return OutExperimentationZone
     */
    public function setNature(OezNature $nature): OutExperimentationZone
    {
        $this->nature = $nature;
        return $this;
    }

    /**
     * @param Experiment|null $experiment
     * @return OutExperimentationZone
     */
    public function setExperiment(?Experiment $experiment): OutExperimentationZone
    {
        $this->experiment = $experiment;
        return $this;
    }

    public function getColor(): ?int
    {
        return $this->color;
    }

    public function setColor(?int $color): OutExperimentationZone
    {
        $this->color = $color;
        return $this;
    }

    function parent(): ?BusinessObject
    {
        return $this->unitPlot ?? $this->subBlock ?? $this->block ?? $this->experiment;
    }

    function children(): array
    {
        return [];
    }

}
