<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Device\Dto;

use Mobile\Shared\Dto\HasAnnotationInput;

/**
 * Class EvaluableInput.
 */
abstract class EvaluableInput extends HasAnnotationInput
{
    /**
     * @var string
     */
    private $uri;

    /**
     * @var string
     */
    private $name;

    /**
     * @var NoteInput[]
     */
    private $notes;

    /**
     * @return string
     */
    public function getUri(): string
    {
        return $this->uri;
    }

    /**
     * @param string $uri
     * @return EvaluableInput
     */
    public function setUri(string $uri): EvaluableInput
    {
        $this->uri = $uri;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return EvaluableInput
     */
    public function setName(string $name): EvaluableInput
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return NoteInput[]
     */
    public function getNotes(): array
    {
        return $this->notes;
    }

    /**
     * @param NoteInput[] $notes
     * @return EvaluableInput
     */
    public function setNotes(array $notes): EvaluableInput
    {
        $this->notes = $notes;
        return $this;
    }

}
