<?php

namespace Mobile\Device\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Factor.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\FactorRepository")
 * @ORM\Table(name="factor", schema="adonis")
 */
class Factor extends IdentifiedEntity
{
    /**
     * @var Protocol
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Protocol", inversedBy="factors")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $protocol;

    /**
     * @var Collection<Modality>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\Modality", mappedBy="factor", cascade={"persist", "remove", "detach"})
     */
    private $modalities;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * Factor constructor.
     */
    public function __construct()
    {
        $this->modalities = new ArrayCollection();
    }

    /**
     * @return Protocol
     */
    public function getProtocol(): Protocol
    {
        return $this->protocol;
    }

    /**
     * @param Protocol $protocol
     * @return Factor
     */
    public function setProtocol(Protocol $protocol): Factor
    {
        $this->protocol = $protocol;
        return $this;
    }

    /**
     * @return Collection<Modality>
     */
    public function getModalities(): Collection
    {
        return $this->modalities;
    }

    /**
     * @param Modality $modality
     */
    public function addModality(Modality $modality): void
    {
        if (!$this->modalities->contains($modality)) {
            $modality->setFactor($this);
            $this->modalities->add($modality);
        }
    }

    /**
     * @param Modality $modality
     */
    public function removeModality(Modality $modality): void
    {
        if ($this->modalities->contains($modality)) {
            $modality->setFactor(null);
            $this->modalities->removeElement($modality);
        }
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Factor
     */
    public function setName(string $name): Factor
    {
        $this->name = $name;
        return $this;
    }
}
