<?php

namespace Mobile\Measure\Entity\Test;

use Mobile\Measure\Entity\Test\Base\Test;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class PreconditionedCalculation.
 *
 * @ORM\Entity()
 * @ORM\Table(name="test_preconditioned", schema="adonis")
 */
class PreconditionedCalculation extends Test
{
    const PRECONDITIONED_TEST = 'PreconditionedCalculation';

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="preconditionedCalculations")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    protected $variable;

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=false)
     */
    private $comparisonVariable;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $condition;

    /**
     * @var float|null
     *
     * @ORM\Column(type="float", nullable=true)
     */
    private $comparedValue;

    /**
     * @var Variable|null
     *
     * @ORM\OneToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=true)
     */
    private $comparedVariable;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $affectationValue;

    /**
     * @return string
     */
    public function getTypeTest(): string
    {
        return static::PRECONDITIONED_TEST;
    }

    /**
     * @return Variable
     */
    public function getComparisonVariable(): Variable
    {
        return $this->comparisonVariable;
    }

    /**
     * @param Variable $comparisonVariable
     * @return PreconditionedCalculation
     */
    public function setComparisonVariable(Variable $comparisonVariable): PreconditionedCalculation
    {
        $this->comparisonVariable = $comparisonVariable;
        return $this;
    }

    /**
     * @return string
     */
    public function getCondition(): string
    {
        return $this->condition;
    }

    /**
     * @param string $condition
     * @return PreconditionedCalculation
     */
    public function setCondition(string $condition): PreconditionedCalculation
    {
        $this->condition = $condition;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getComparedValue(): ?float
    {
        return $this->comparedValue;
    }

    /**
     * @param float|null $comparedValue
     * @return PreconditionedCalculation
     */
    public function setComparedValue(?float $comparedValue): PreconditionedCalculation
    {
        $this->comparedValue = $comparedValue;
        return $this;
    }

    /**
     * @return Variable|null
     */
    public function getComparedVariable(): ?Variable
    {
        return $this->comparedVariable;
    }

    /**
     * @param Variable|null $comparedVariable
     * @return PreconditionedCalculation
     */
    public function setComparedVariable(?Variable $comparedVariable): PreconditionedCalculation
    {
        $this->comparedVariable = $comparedVariable;
        return $this;
    }

    /**
     * @return string
     */
    public function getAffectationValue(): string
    {
        return $this->affectationValue;
    }

    /**
     * @param string $affectationValue
     * @return PreconditionedCalculation
     */
    public function setAffectationValue(string $affectationValue): PreconditionedCalculation
    {
        $this->affectationValue = $affectationValue;
        return $this;
    }
}
