<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Scale
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\ScaleRepository")
 * @ORM\Table(name="scale_data", schema="adonis")
 */
class Scale extends IdentifiedEntity
{
    /**
     * @var Variable|null
     *
     * @ORM\OneToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="scale")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    private $variable;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $minValue;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $maxValue;

    /**
     * @var Collection<Mark>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Measure\Entity\Variable\Mark", mappedBy="scale", cascade={"persist", "remove", "detach"})
     */
    private $marks;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false, options={"default"=false})
     */
    private $exclusive;

    /**
     * Scale constructor.
     */
    public function __construct()
    {
        $this->marks = new ArrayCollection();
        $this->exclusive = false;
    }

    /**
     * @return Variable|null
     */
    public function getVariable(): ?Variable
    {
        return $this->variable;
    }

    /**
     * @param Variable|null $variable
     * @return Scale
     */
    public function setVariable(?Variable $variable): Scale
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Scale
     */
    public function setName(string $name): Scale
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getMinValue(): int
    {
        return $this->minValue;
    }

    /**
     * @param int $minValue
     * @return Scale
     */
    public function setMinValue(int $minValue): Scale
    {
        $this->minValue = $minValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getMaxValue(): int
    {
        return $this->maxValue;
    }

    /**
     * @param int $maxValue
     * @return Scale
     */
    public function setMaxValue(int $maxValue): Scale
    {
        $this->maxValue = $maxValue;
        return $this;
    }

    /**
     * @return Collection
     */
    public function getMarks(): Collection
    {
        return $this->marks;
    }

    /**
     * @param Mark $mark
     */
    public function addMark(Mark $mark): void
    {
        if (!$this->marks->contains($mark)) {
            $mark->setScale($this);
            $this->marks->add($mark);
        }
    }

    /**
     * @param Mark $mark
     */
    public function removeMark(Mark $mark): void
    {
        if ($this->marks->contains($mark)) {
            $this->marks->remove($mark);
        }
    }

    /**
     * @return bool
     */
    public function isExclusive(): bool
    {
        return $this->exclusive;
    }

    /**
     * @param bool $exclusive
     * @return Scale
     */
    public function setExclusive(bool $exclusive): Scale
    {
        $this->exclusive = $exclusive;
        return $this;
    }
}
