<?php

namespace Mobile\Project\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class NatureZHE
 *
 * @ORM\Entity(repositoryClass="Mobile\Project\Repository\NatureZHERepository")
 * @ORM\Table(name="nature_zhe", schema="adonis")
 */
class NatureZHE extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;
    /**
     * @var string| null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $color;
    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $texture;

    /**
     * @var DataEntryProject | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="naturesZHE")
     */
    private $project;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return NatureZHE
     */
    public function setName(string $name): NatureZHE
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getColor(): ?string
    {
        return $this->color;
    }

    /**
     * @param string|null $color
     * @return NatureZHE
     */
    public function setColor(?string $color): NatureZHE
    {
        $this->color = $color;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTexture(): ?string
    {
        return $this->texture;
    }

    /**
     * @param string|null $texture
     * @return NatureZHE
     */
    public function setTexture(?string $texture): NatureZHE
    {
        $this->texture = $texture;
        return $this;
    }

    /**
     * @return DataEntryProject|null
     */
    public function getProject(): ?DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject|null $project
     * @return NatureZHE
     */
    public function setProject(?DataEntryProject $project): NatureZHE
    {
        $this->project = $project;
        return $this;
    }

}
