<?php

namespace Webapp\Core\Entity\DataView;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Entity\Block;
use Webapp\Core\Entity\Experiment;
use Webapp\Core\Entity\FieldMeasure;
use Webapp\Core\Entity\GeneratorVariable;
use Webapp\Core\Entity\Individual;
use Webapp\Core\Entity\ProjectData;
use Webapp\Core\Entity\SemiAutomaticVariable;
use Webapp\Core\Entity\Session;
use Webapp\Core\Entity\SimpleVariable;
use Webapp\Core\Entity\SubBlock;
use Webapp\Core\Entity\SurfacicUnitPlot;
use Webapp\Core\Entity\Treatment;
use Webapp\Core\Entity\UnitPlot;
use Webapp\Core\Enumeration\PathLevelEnum;

/**
 * @ApiResource(
 *      normalizationContext={"groups"={"data_view_item"}},
 *      collectionOperations={
 *          "get"={},
 *      },
 *      itemOperations={
 *          "get"={},
 *      },
 *  )
 *
 *
 * @ApiFilter(SearchFilter::class, properties={"projectData": "exact", "session": "exact"})
 *
 * @ORM\Entity(readOnly=true)
 * @ORM\Table(name="view_data_business_object", schema="webapp")
 */
class DataViewBusinessObject
{
    /**
     * @ORM\Id()
     * @ORM\Column()
     */
    private string $fakeId;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $platform;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $experiment;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $block;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $subBlock;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $surfacicUnitPlot;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $unitPlot;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $individual;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Experiment")
     */
    private Experiment $experimentTarget;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Block")
     */
    private Block $blockTarget;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SubBlock")
     */
    private SubBlock $subBlockTarget;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SurfacicUnitPlot")
     */
    private SurfacicUnitPlot $surfacicUnitPlotTarget;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\UnitPlot")
     */
    private UnitPlot $unitPlotTarget;

    /**
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Individual")
     */
    private Individual $individualTarget;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private bool $dead;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private DateTime $appeared;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private DateTime $disappeared;

    /**
     * @Groups({"data_view_item"})
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Treatment")
     */
    private Treatment $treatment;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private int $x;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private int $y;

    /**
     * @Groups({"data_view_item"})
     * @ORM\Column()
     */
    private string $identifier;

    /**
     * @Groups({"data_view_item"})
     * @return string|null
     */
    public function getTargetType(): ?string
    {
        $target = $this->getTarget();
        if ($target instanceof Individual) {
            return PathLevelEnum::INDIVIDUAL;
        } elseif ($target instanceof SurfacicUnitPlot) {
            return PathLevelEnum::SURFACIC_UNIT_PLOT;
        } elseif ($target instanceof UnitPlot) {
            return PathLevelEnum::UNIT_PLOT;
        } elseif ($target instanceof SubBlock) {
            return PathLevelEnum::SUB_BLOCK;
        } elseif ($target instanceof Block) {
            return PathLevelEnum::BLOCK;
        } elseif ($target instanceof Experiment) {
            return PathLevelEnum::EXPERIMENT;
        } else {
            return null;
        }
    }

    /**
     * @Groups({"data_view_item"})
     * @return Block|Experiment|Individual|SubBlock|SurfacicUnitPlot|UnitPlot
     */
    public function getTarget(){
        return $this->individualTarget ?? $this->surfacicUnitPlotTarget ?? $this->unitPlotTarget ?? $this->subBlockTarget ?? $this->blockTarget ?? $this->experimentTarget;
    }

    public function getPlatform(): string
    {
        return $this->platform;
    }

    public function getExperiment(): string
    {
        return $this->experiment;
    }

    public function getBlock(): string
    {
        return $this->block;
    }

    public function getSubBlock(): string
    {
        return $this->subBlock;
    }

    public function getSurfacicUnitPlot(): string
    {
        return $this->surfacicUnitPlot;
    }

    public function getUnitPlot(): string
    {
        return $this->unitPlot;
    }

    public function getIndividual(): string
    {
        return $this->individual;
    }

    public function isDead(): bool
    {
        return $this->dead;
    }

    public function getAppeared(): DateTime
    {
        return $this->appeared;
    }

    public function getDisappeared(): DateTime
    {
        return $this->disappeared;
    }

    public function getTreatment(): Treatment
    {
        return $this->treatment;
    }

    public function getX(): int
    {
        return $this->x;
    }

    public function getY(): int
    {
        return $this->y;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getFakeId(): string
    {
        return $this->fakeId;
    }
}
