<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\EditBusinessObjectOperation;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "move"={
 *              "controller"=EditBusinessObjectOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Edit one or more buisness object with the same delta",
 *                  "description": "Edit all items with given IRI to a new position"
 *              }
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class Edit
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var array<array<string>>
     */
    private array $objectIris;
    /**
     * @var int | null
     */
    private ?int $dx;
    /**
     * @var int | null
     */
    private ?int $dy;

    private ?int $color;

    public function __construct()
    {
        $this->objectIris = [];
        $this->dx = null;
        $this->dy = null;
        $this->color = null;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return Edit
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return \string[][]
     */
    public function getObjectIris(): array
    {
        return $this->objectIris;
    }

    /**
     * @param \string[][] $objectIris
     * @return Edit
     */
    public function setObjectIris(array $objectIris): Edit
    {
        $this->objectIris = $objectIris;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getDx(): ?int
    {
        return $this->dx;
    }

    /**
     * @param int|null $dx
     * @return Edit
     */
    public function setDx(?int $dx): Edit
    {
        $this->dx = $dx;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getDy(): ?int
    {
        return $this->dy;
    }

    /**
     * @param int|null $dy
     * @return Edit
     */
    public function setDy(?int $dy): Edit
    {
        $this->dy = $dy;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getColor(): ?int
    {
        return $this->color;
    }

    /**
     * @param int|null $color
     * @return Edit
     */
    public function setColor(?int $color): Edit
    {
        $this->color = $color;
        return $this;
    }
}
