<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\Site;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Validator\UniqueAttributeInParent;

/**
 * Class Modality
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *         "post"={
 *              "security_post_denormalize"="is_granted('ROLE_PLATFORM_MANAGER', object.getSite())",
 *          }
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_PLATFORM_MANAGER')"},
 *         "patch"={
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER', object.getSite())",
 *          },
 *         "delete"={"security"="is_granted('ROLE_PLATFORM_MANAGER', object.getSite())"},
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={"nature": "exact", "site": "exact"})
 *
 * @ORM\Entity
 * @ORM\Table(name="oez_nature", schema="webapp")
 */
class OezNature extends IdentifiedEntity
{
    /**
     * @var string
     * @UniqueAttributeInParent(parentsAttributes={"site.oezNatures"})
     * @Groups({"design_explorer_view", "platform_full_view"})
     * @ORM\Column(type="string")
     */
    private string $nature;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Groups({"platform_full_view"})
     */
    private int $color;

    /**
     * @var int | null
     *
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"platform_full_view"})
     */
    private ?int $texture;

    /**
     * @var Site
     *
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\Site", inversedBy="oezNatures")
     */
    private Site $site;

    /**
     * @var Collection | array<OutExperimentationZone>
     *
     * @ORM\OneToMany(targetEntity="Webapp\Core\Entity\OutExperimentationZone", mappedBy="nature")
     */
    private $outExperimentationZones;

    public function __construct()
    {
        $this->outExperimentationZones = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getNature(): string
    {
        return $this->nature;
    }

    /**
     * @param string $nature
     * @return OezNature
     */
    public function setNature(string $nature): OezNature
    {
        $this->nature = $nature;
        return $this;
    }

    /**
     * @return int
     */
    public function getColor(): int
    {
        return $this->color;
    }

    /**
     * @param int $color
     * @return OezNature
     */
    public function setColor(int $color): OezNature
    {
        $this->color = $color;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getTexture(): ?int
    {
        return $this->texture;
    }

    /**
     * @param int|null $texture
     * @return OezNature
     */
    public function setTexture(?int $texture): OezNature
    {
        $this->texture = $texture;
        return $this;
    }

    /**
     * @return Site
     */
    public function getSite(): Site
    {
        return $this->site;
    }

    /**
     * @param Site $site
     * @return OezNature
     */
    public function setSite(Site $site): OezNature
    {
        $this->site = $site;
        return $this;
    }

    /**
     * @return Collection|OutExperimentationZone[]
     */
    public function getOutExperimentationZones()
    {
        return $this->outExperimentationZones;
    }

    /**
     * @param Collection|OutExperimentationZone[] $outExperimentationZones
     * @return OezNature
     */
    public function setOutExperimentationZones($outExperimentationZones)
    {
        $this->outExperimentationZones = $outExperimentationZones;
        return $this;
    }

}
