<?php

namespace Webapp\FileManagement\Entity\Base;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\SoftDeleteable\Traits\SoftDeleteableEntity;
use Shared\FileManagement\Entity\UserLinkedJob;
use Symfony\Component\Serializer\Annotation\Groups;
use Vich\UploaderBundle\Mapping\Annotation as Vich;
use Webapp\FileManagement\Service\ProjectFileInterface;

/**
 * Class UserLinkedFileJob
 * @package Webapp\FileManagement\Entity
 *
 * @ORM\MappedSuperclass()
 * @Gedmo\SoftDeleteable()
 * @Vich\Uploadable()
 */
abstract class UserLinkedFileJob extends UserLinkedJob implements ProjectFileInterface
{

    use SoftDeleteableEntity;
    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @var string
     *
     * @Groups({"user_linked_file_job_read"})
     *
     * @ORM\Column(type="string")
     */
    protected $status;

    /**
     * @var string|null
     *
     * @ORM\Column(nullable=true)
     */
    protected $filePath;

    /**
     * @Vich\UploadableField(mapping="project_file", fileNameProperty="filePath")
     */
    protected $file;

    /**
     * @var string|null
     *
     * @Groups({"user_linked_file_job_read"})
     */
    protected $contentUrl;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     *
     */
    protected $uniqDirectoryName;

    /**
     * @var DateTime
     *
     * @Groups({"user_linked_file_job_read"})
     *
     * @ORM\Column(type="datetime")
     */
    protected $uploadDate;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return UserLinkedFileJob
     */
    public function setName(string $name): UserLinkedFileJob
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * @param mixed $file
     * @return UserLinkedFileJob
     */
    public function setFile($file)
    {
        $this->file = $file;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilePath(): ?string
    {
        return $this->filePath;
    }

    /**
     * @param string|null $filePath
     * @return UserLinkedFileJob
     */
    public function setFilePath(?string $filePath): UserLinkedFileJob
    {
        $this->filePath = $filePath;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getContentUrl(): ?string
    {
        return $this->contentUrl;
    }

    /**
     * @param string|null $contentUrl
     * @return UserLinkedFileJob
     */
    public function setContentUrl(?string $contentUrl): UserLinkedFileJob
    {
        $this->contentUrl = $contentUrl;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUniqDirectoryName(): ?string
    {
        return $this->uniqDirectoryName;
    }

    /**
     * @param string|null $uniqDirectoryName
     * @return UserLinkedFileJob
     */
    public function setUniqDirectoryName(?string $uniqDirectoryName): UserLinkedFileJob
    {
        $this->uniqDirectoryName = $uniqDirectoryName;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getUploadDate(): DateTime
    {
        return $this->uploadDate;
    }

    /**
     * @param DateTime $uploadDate
     * @return UserLinkedFileJob
     */
    public function setUploadDate(DateTime $uploadDate): UserLinkedFileJob
    {
        $this->uploadDate = $uploadDate;
        return $this;
    }
}
