<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = '__root__';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'api-platform/core' => 'v2.6.8@ff3aab5b196709c721960c0bb4f1d52759af737d',
  'aws/aws-crt-php' => 'v1.2.4@eb0c6e4e142224a10b08f49ebf87f32611d162b2',
  'aws/aws-sdk-php' => '3.300.6@957ccef631684d612d01ced2fa3b0506f2ec78c3',
  'behat/transliterator' => 'v1.5.0@baac5873bac3749887d28ab68e2f74db3a4408af',
  'cocur/background-process' => 'v0.7@9ae2902922f02ec5544d723756758eb7304c6869',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'doctrine/annotations' => '1.14.3@fb0d71a7393298a7b232cbf4c8b1f73f3ec3d5af',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '1.8.0@2b44dd4cbca8b5744327de78bafef5945c7e7b5e',
  'doctrine/common' => '3.4.3@8b5e5650391f851ed58910b3e3d48a71062eeced',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => '1.1.3@dfbaa3c2d2e9a9df1118213f3b8b0c597bb99fab',
  'doctrine/doctrine-bundle' => '2.7.2@22d53b2c5ad03929628fb4a928b01135585b7179',
  'doctrine/doctrine-migrations-bundle' => '2.2.3@0a081b55a88259a887af7be654743a8c5f703e99',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.18.1@e6eef1a97d41f1ee244b6e69d7359d00cb3e4c4a',
  'doctrine/persistence' => '3.2.0@63fee8c33bef740db6730eb2a750cd3da6495603',
  'doctrine/sql-formatter' => '1.2.0@a321d114e0a18e6497f8a2cd6f890e000cc17ecc',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'fig/link-util' => '1.1.2@5d7b8d04ed3393b4b59968ca1e906fb7186d81e8',
  'friendsofphp/proxy-manager-lts' => 'v1.0.16@ecadbdc9052e4ad08c60c8a02268712e50427f7c',
  'gedmo/doctrine-extensions' => 'v3.13.0@291d0c527d2dc9ee07b888c9a4e2a179893f08ab',
  'gesdinet/jwt-refresh-token-bundle' => 'v1.3.0@83d687cc461b4bdae9ffc6efda97464093cae739',
  'guzzlehttp/guzzle' => '7.8.1@41042bc7ab002487b876a0683fc8dce04ddce104',
  'guzzlehttp/promises' => '2.0.2@bbff78d96034045e58e13dedd6ad91b5d1253223',
  'guzzlehttp/psr7' => '2.6.2@45b30f99ac27b5ca93cb4831afe16285f57b8221',
  'jms/metadata' => '2.8.0@7ca240dcac0c655eb15933ee55736ccd2ea0d7a6',
  'knplabs/gaufrette' => 'v0.10.0@ef5ec9d72c06d21febfa09b36d5c3d8e3af9cf8b',
  'knplabs/knp-gaufrette-bundle' => 'v0.7.2@9cf8706e9f01d4a7ee5013261a10768efdfebb0f',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-eventmanager' => '3.5.0@41f7209428f37cab9573365e361f4078209aaafa',
  'laminas/laminas-zendframework-bridge' => '1.6.1@e112dd2c099f4f6142c16fc65fda89a638e06885',
  'lcobucci/clock' => '2.0.0@353d83fe2e6ae95745b16b3d911813df6a05bfb3',
  'lcobucci/jwt' => '4.3.0@4d7de2fe0d51a96418c0d04004986e410e87f6b4',
  'lexik/jwt-authentication-bundle' => 'v2.20.3@a196d68d07dd5486a523cc3415620badbb5d25c2',
  'mmucklo/queue-bundle' => '6.7.0@11481017c777fd18930d3e3f5d26f5f07e9f4d4a',
  'monolog/monolog' => '2.9.2@437cb3628f4cf6042cc10ae97fc2b8472e48ca1f',
  'mtdowling/jmespath.php' => '2.7.0@bbb69a935c2cbb0c03d7f481a238027430f6440b',
  'namshi/jose' => '7.2.3@89a24d7eb3040e285dd5925fcad992378b82bcff',
  'nelmio/cors-bundle' => '2.4.0@78fcdb91f76b080a1008133def9c7f613833933d',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.3.0@622548b623e81ca6d78b721c5e029f4ce664f170',
  'phpdocumentor/type-resolver' => '1.8.2@153ae662783729388a584b4361f2545e4d841e3c',
  'phpstan/phpdoc-parser' => '1.26.0@231e3186624c03d7e7c890ec662b81e6b0405227',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.0.2@e616d01114759c4c489f93b099585439f795fe35',
  'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'stof/doctrine-extensions-bundle' => 'v1.10.1@299d5333ce83941069852be36b949abbc776bf1d',
  'symfony/apache-pack' => 'v1.0.1@3aa5818d73ad2551281fc58a75afd9ca82622e6c',
  'symfony/asset' => 'v5.4.35@0e98032106d18e57f57176d616e3fae80db7a845',
  'symfony/cache' => 'v5.4.36@a30f316214d908cf5874f700f3f3fb29ceee91ba',
  'symfony/cache-contracts' => 'v2.5.2@64be4a7acb83b6f2bf6de9a02cee6dad41277ebc',
  'symfony/config' => 'v5.4.36@0a4f363dc2f13d2f871f917cc563796d9ddc78d1',
  'symfony/console' => 'v5.4.36@39f75d9d73d0c11952fdcecf4877b4d0f62a8f6e',
  'symfony/dependency-injection' => 'v5.4.36@cc1fb237cd0e6da33005062b13b8485deb6e4440',
  'symfony/deprecation-contracts' => 'v2.5.2@e8b495ea28c1d97b5e0c121748d6f9b53d075c66',
  'symfony/doctrine-bridge' => 'v5.4.36@473f59f15243b16cdc298b671074626f0582d81a',
  'symfony/dotenv' => 'v5.4.35@4de488440104b99d2e7c0717ee432e760b061e32',
  'symfony/error-handler' => 'v5.4.36@90b1d7799bfc1b3ed5f902e8b334eeb7dba537a1',
  'symfony/event-dispatcher' => 'v5.4.35@7a69a85c7ea5bdd1e875806a99c51a87d3a74b38',
  'symfony/event-dispatcher-contracts' => 'v2.5.2@f98b54df6ad059855739db6fcbc2d36995283fe1',
  'symfony/expression-language' => 'v5.4.35@d59441c10a5a73cd9d4d778b8253595a16f6716d',
  'symfony/filesystem' => 'v5.4.35@5a553607d4ffbfa9c0ab62facadea296c9db7086',
  'symfony/finder' => 'v5.4.35@abe6d6f77d9465fed3cd2d029b29d03b56b56435',
  'symfony/flex' => 'v1.21.5@6b46a001639f810d01f4f1b39be1291192a711d4',
  'symfony/form' => 'v5.4.36@3bbf663b8021a5a7b8f4bf9b868354db6611a514',
  'symfony/framework-bundle' => 'v5.4.36@224f69093099a507cf84d8c48ceb29e8653a5896',
  'symfony/http-foundation' => 'v5.4.35@f2ab692a22aef1cd54beb893aa0068bdfb093928',
  'symfony/http-kernel' => 'v5.4.36@63a872e01fd70802b77023e2f5924170c99b2825',
  'symfony/intl' => 'v5.4.35@2fb503f81cd8032a624c55764d1fbaf893aa3cf4',
  'symfony/ldap' => 'v5.4.35@b6ddb1755262d09a3c220d21a55334047f6920ca',
  'symfony/mailer' => 'v5.4.36@b57d722f2bf6e1dc08df9c86efbfdcaaba89693b',
  'symfony/mime' => 'v5.4.35@ee94d9b538f93abbbc1ee4ccff374593117b04a9',
  'symfony/monolog-bridge' => 'v5.4.35@83e7438fd2ead9af4fd2fac7bb9b6fc0e8823387',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/options-resolver' => 'v5.4.21@4fe5cf6ede71096839f0e4b4444d65dd3a7c1eb9',
  'symfony/password-hasher' => 'v5.4.36@a0c08f9045230ef73d25617b2c0e0b56d8feb0a2',
  'symfony/polyfill-intl-grapheme' => 'v1.29.0@32a9da87d7b3245e09ac426c83d334ae9f06f80f',
  'symfony/polyfill-intl-icu' => 'v1.29.0@07094a28851a49107f3ab4f9120ca2975a64b6e1',
  'symfony/polyfill-intl-idn' => 'v1.29.0@a287ed7475f85bf6f61890146edbc932c0fff919',
  'symfony/polyfill-intl-normalizer' => 'v1.29.0@bc45c394692b948b4d383a08d7753968bed9a83d',
  'symfony/polyfill-mbstring' => 'v1.29.0@9773676c8a1bb1f8d4340a62efe641cf76eda7ec',
  'symfony/polyfill-php72' => 'v1.29.0@861391a8da9a04cbad2d232ddd9e4893220d6e25',
  'symfony/polyfill-php73' => 'v1.29.0@21bd091060673a1177ae842c0ef8fe30893114d2',
  'symfony/polyfill-php80' => 'v1.29.0@87b68208d5c1188808dd7839ee1e6c8ec3b02f1b',
  'symfony/polyfill-php81' => 'v1.29.0@c565ad1e63f30e7477fc40738343c62b40bc672d',
  'symfony/process' => 'v5.4.36@4fdf34004f149cc20b2f51d7d119aa500caad975',
  'symfony/property-access' => 'v5.4.35@f1341758d8046cfff0ac748a0cad238f917191d4',
  'symfony/property-info' => 'v5.4.35@d30d48f366ad2bfbf521256be85eb1c182c29198',
  'symfony/proxy-manager-bridge' => 'v5.4.21@a4cf96f3acfa252503a216bea877478f9621c7c0',
  'symfony/routing' => 'v5.4.35@86c5a06a61ddaf17efa1403542e3d7146af96203',
  'symfony/security-bundle' => 'v5.4.36@ce85db13f4049dd40fbd7b98999f77f146191d35',
  'symfony/security-core' => 'v5.4.35@3cbacefb2a350ed39950f93c8a054c2eb625fb69',
  'symfony/security-csrf' => 'v5.4.35@6728ed79d7f9aae3b86fca7ea554f1c46bae1e0b',
  'symfony/security-guard' => 'v5.4.35@b6fb8c88f7cd544db761de2d1c3618cbc5c1b9e7',
  'symfony/security-http' => 'v5.4.36@87ee1ea2b86740fc6a0104f165bebbe0b08b66ba',
  'symfony/serializer' => 'v5.4.36@05137a513f4c5a5e56ffbcf53847a93284b49f67',
  'symfony/service-contracts' => 'v2.5.2@4b426aac47d6427cc1a1d0f7e2ac724627f5966c',
  'symfony/stopwatch' => 'v5.4.35@887762aa99ff16f65dc8b48aafead415f942d407',
  'symfony/string' => 'v5.4.36@4e232c83622bd8cd32b794216aa29d0d266d353b',
  'symfony/translation' => 'v5.4.35@77d7d1e46f52827585e65e6cd6f52a2542e59c72',
  'symfony/translation-contracts' => 'v2.5.2@136b19dd05cdf0709db6537d058bcab6dd6e2dbe',
  'symfony/twig-bridge' => 'v5.4.36@14a73aa32c9769b823f7a6f6c018d7c576e49fe7',
  'symfony/twig-bundle' => 'v5.4.36@37a338733c456fc8cd056c2e0f20bae020cbec70',
  'symfony/validator' => 'v5.4.36@e80028e0f7814a8824fc1f474f1566a7bddceec5',
  'symfony/var-dumper' => 'v5.4.36@2e9c2b11267119d9c90d6b3fdce5e4e9f15e2e90',
  'symfony/var-exporter' => 'v5.4.35@abb0a151b62d6b07e816487e20040464af96cae7',
  'symfony/web-link' => 'v5.4.35@5eb4930dd8bdf233d32e4e3c2dfa8241051b6320',
  'symfony/webpack-encore-bundle' => 'v1.17.2@471ebbc03072dad6e31840dc317bc634a32785f5',
  'symfony/yaml' => 'v5.4.35@e78db7f5c70a21f0417a31f414c4a95fe76c07e4',
  'twig/extra-bundle' => 'v3.8.0@32807183753de0388c8e59f7ac2d13bb47311140',
  'twig/twig' => 'v3.8.0@9d15f0ac07f44dc4217883ec6ae02fd555c6f71d',
  'vich/uploader-bundle' => '1.23.1@7d20347fc92243ab8e261c0b6196c25b77c579f8',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'amphp/amp' => 'v2.6.2@9d5100cebffa729aaffecd3ad25dc5aeea4f13bb',
  'amphp/byte-stream' => 'v1.8.1@acbd8002b3536485c997c4e019206b3f10ca15bd',
  'composer/pcre' => '3.1.1@00104306927c7a0919b4ced2aaa6782c1e61a3c9',
  'composer/semver' => '3.4.0@35e8d0af4486141bc745f23a29cc2091eb624a32',
  'composer/xdebug-handler' => '3.0.3@ced299686f41dce890debac69273b47ffe98a40c',
  'deployer/deployer' => 'v6.9.0@c4380effdc9f6d9c6ae549bb76f0a22bcb1d31d2',
  'deployer/phar-update' => 'v2.2.0@9ad07422f2cd43a1382ee8e134bdcd3a374848e3',
  'deployer/recipes' => '6.2.2@84b3229c518c094a950e1fe785b7b8f9598770fe',
  'dnoegel/php-xdg-base-dir' => 'v0.1.1@8f8a6e48c5ecb0f991c2fdcf5f154a47d85f9ffd',
  'doctrine/data-fixtures' => '1.6.7@ae4e845decbe177348fdbecd04331f4fb96aa301',
  'doctrine/doctrine-fixtures-bundle' => '3.4.5@5988484f79362cd7d06564bd11be7ce622e08c87',
  'felixfbecker/advanced-json-rpc' => 'v3.2.1@b5f37dbff9a8ad360ca341f3240dc1c168b45447',
  'felixfbecker/language-server-protocol' => 'v1.5.2@6e82196ffd7c62f7794d778ca52b69feec9f2842',
  'fidry/cpu-core-counter' => '1.1.0@f92996c4d5c1a696a6a970e20f7c4216200fcc42',
  'myclabs/deep-copy' => '1.11.1@7284c22080590fb39f2ffa3e9057f10a4ddd0e0c',
  'netresearch/jsonmapper' => 'v4.4.1@132c75c7dd83e45353ebb9c6c9f591952995bbf0',
  'nikic/php-parser' => 'v4.18.0@1bcbb2179f97633e98bbbc87044ee2611c7d7999',
  'phar-io/manifest' => '2.0.3@97803eca37d319dfa7826cc2437fc020857acb53',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.30@ca2bd87d2f9215904682a9cb9bb37dda98e76089',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.17@1a156980d78a6666721b7e8e8502fe210b587fcd',
  'pimple/pimple' => 'v3.5.0@a94b3a4db7fb774b3d78dad2315ddc07629e1bed',
  'sebastian/cli-parser' => '1.0.1@442e7c7e687e42adc03470c7b668bc4b2402c0b2',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.5@74be17022044ebaaecfdf0c5cd504fc9cd5a7131',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.5@ac230ed27f0f98f597c8a2b6eb7ac563af5e5b9d',
  'sebastian/global-state' => '5.0.6@bde739e7565280bda77be70044ac1047bc007e34',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.3@0f4443cb3a1d92ce809899753bc0d5d5a8dd19a8',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'spatie/array-to-xml' => '2.17.1@5cbec9c6ab17e320c58a259f0cebe88bde4a7c46',
  'symfony/browser-kit' => 'v5.4.35@2f6f979b579ed1c051465c3c2fb81daf5bb4a002',
  'symfony/css-selector' => 'v5.4.35@9e615d367e2bed41f633abb383948c96a2dbbfae',
  'symfony/debug-bundle' => 'v5.4.35@dfecbdbad82e59002c3fcf2322ec3a65f96d4f95',
  'symfony/dom-crawler' => 'v5.4.35@e3b4806f88abf106a411847a78619a542e71de29',
  'symfony/http-client' => 'v5.4.36@3e147c34ce44644f7bf7c2b8c8ecf76c0aac94b9',
  'symfony/http-client-contracts' => 'v2.5.2@ba6a9f0e8f3edd190520ee3b9a958596b6ca2e70',
  'symfony/maker-bundle' => 'v1.43.0@e3f9a1d9e0f4968f68454403e820dffc7db38a59',
  'symfony/phpunit-bridge' => 'v5.4.36@c4d978502e03cc6a45d8454e06e59ff22d4907d5',
  'symfony/web-profiler-bundle' => 'v5.4.36@93df9846358093676fe0b029d0c4725f7935742f',
  'theseer/tokenizer' => '1.2.2@b2ad5003ca10d4ee50a12da31de12a5774ba6b96',
  'vimeo/psalm' => '5.22.2@d768d914152dbbf3486c36398802f74e80cfde48',
  'paragonie/random_compat' => '2.*@',
  'symfony/polyfill-ctype' => '*@',
  'symfony/polyfill-iconv' => '*@',
  'symfony/polyfill-php71' => '*@',
  'symfony/polyfill-php70' => '*@',
  'symfony/polyfill-php56' => '*@',
  '__root__' => '1.0.0+no-version-set@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
