<?php

namespace Dtc\QueueBundle\Model;

/**
 * Class QueueWorker.
 *
 * Placeholder for future Queue Worker that sits and drains the queue
 */
class Run
{
    protected $id;
    protected $startedAt;
    protected $endedAt;
    protected $elapsed;
    protected $duration; // How long to run for in seconds
    protected $lastHeartbeatAt;
    protected $maxCount;
    protected $processed; // Number of jobs processed
    protected $hostname;
    protected $pid;
    protected $processTimeout;
    protected $currentJobId;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return \DateTime|null
     */
    public function getStartedAt()
    {
        return $this->startedAt;
    }

    public function setStartedAt(\DateTime $startedAt)
    {
        $this->startedAt = $startedAt;
    }

    /**
     * @return \DateTime|null
     */
    public function getEndedAt()
    {
        return $this->endedAt;
    }

    public function setEndedAt(\DateTime $endedAt)
    {
        $this->endedAt = $endedAt;
    }

    /**
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * @param int $duration
     */
    public function setDuration($duration)
    {
        $this->duration = $duration;
    }

    /**
     * @return \DateTime|null
     */
    public function getLastHeartbeatAt()
    {
        return $this->lastHeartbeatAt;
    }

    public function setLastHeartbeatAt(\DateTime $lastHeartbeatAt)
    {
        $this->lastHeartbeatAt = $lastHeartbeatAt;
    }

    /**
     * @return int
     */
    public function getMaxCount()
    {
        return $this->maxCount;
    }

    /**
     * @param int $maxCount
     */
    public function setMaxCount($maxCount)
    {
        $this->maxCount = $maxCount;
    }

    /**
     * @return int
     */
    public function getProcessed()
    {
        return $this->processed;
    }

    /**
     * @param int $processed
     */
    public function setProcessed($processed)
    {
        $this->processed = $processed;
    }

    /**
     * @return string|null
     */
    public function getHostname()
    {
        return $this->hostname;
    }

    /**
     * @param string $hostname
     */
    public function setHostname($hostname)
    {
        $this->hostname = $hostname;
    }

    /**
     * @return int|null
     */
    public function getPid()
    {
        return $this->pid;
    }

    /**
     * @param int $pid
     */
    public function setPid($pid)
    {
        $this->pid = $pid;
    }

    /**
     * @return mixed
     */
    public function getElapsed()
    {
        return $this->elapsed;
    }

    /**
     * @param float|null $elapsed
     */
    public function setElapsed($elapsed)
    {
        $this->elapsed = $elapsed;
    }

    /**
     * @return mixed
     */
    public function getProcessTimeout()
    {
        return $this->processTimeout;
    }

    /**
     * @param mixed $processTimeout
     */
    public function setProcessTimeout($processTimeout)
    {
        $this->processTimeout = $processTimeout;
    }

    /**
     * @return mixed
     */
    public function getCurrentJobId()
    {
        return $this->currentJobId;
    }

    /**
     * @param mixed $currentJobId
     */
    public function setCurrentJobId($currentJobId)
    {
        $this->currentJobId = $currentJobId;
    }
}
