<?php

namespace Mobile\Measure\Entity\Test;

use Mobile\Measure\Entity\Test\Base\Test;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class CombinationTest.
 *
 * @ORM\Entity()
 * @ORM\Table(name="test_combination", schema="adonis")
 */
class CombinationTest extends Test
{
    const COMBINATION_TEST = 'CombinationTest';

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="combinationTests")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    protected $variable;

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $firstOperand;

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $secondOperand;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $operator;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $highLimit;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $lowLimit;

    /**
     * @return string
     */
    public function getTypeTest(): string
    {
        return static::COMBINATION_TEST;
    }

    /**
     * @return Variable
     */
    public function getFirstOperand(): Variable
    {
        return $this->firstOperand;
    }

    /**
     * @param Variable $firstOperand
     * @return CombinationTest
     */
    public function setFirstOperand(Variable $firstOperand): CombinationTest
    {
        $this->firstOperand = $firstOperand;
        return $this;
    }

    /**
     * @return Variable
     */
    public function getSecondOperand(): Variable
    {
        return $this->secondOperand;
    }

    /**
     * @param Variable $secondOperand
     * @return CombinationTest
     */
    public function setSecondOperand(Variable $secondOperand): CombinationTest
    {
        $this->secondOperand = $secondOperand;
        return $this;
    }

    /**
     * @return string
     */
    public function getOperator(): string
    {
        return $this->operator;
    }

    /**
     * @param string $operator
     * @return CombinationTest
     */
    public function setOperator(string $operator): CombinationTest
    {
        $this->operator = $operator;
        return $this;
    }

    /**
     * @return float
     */
    public function getHighLimit(): float
    {
        return $this->highLimit;
    }

    /**
     * @param float $highLimit
     * @return CombinationTest
     */
    public function setHighLimit(float $highLimit): CombinationTest
    {
        $this->highLimit = $highLimit;
        return $this;
    }

    /**
     * @return float
     */
    public function getLowLimit(): float
    {
        return $this->lowLimit;
    }

    /**
     * @param float $lowLimit
     * @return CombinationTest
     */
    public function setLowLimit(float $lowLimit): CombinationTest
    {
        $this->lowLimit = $lowLimit;
        return $this;
    }
}
