<?php

namespace Mobile\Measure\Entity\Variable;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class PreviousValue
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\PreviousValueRepository")
 * @ORM\Table(name="previous_value", schema="adonis")
 */
class PreviousValue extends IdentifiedEntity
{
    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="previousValues")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $variable;

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    private $originVariable;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $value;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $objectUri;

    /**
     * @var DateTime|null
     *
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $date;

    /**
     * @var StateCode|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\StateCode")
     * @ORM\JoinColumn(nullable=true)
     */
    private $state;

    /**
     * @return Variable
     */
    public function getVariable(): Variable
    {
        return $this->variable;
    }

    /**
     * @param Variable $variable
     * @return PreviousValue
     */
    public function setVariable(Variable $variable): PreviousValue
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return Variable
     */
    public function getOriginVariable(): Variable
    {
        return $this->originVariable;
    }

    /**
     * @param Variable $originVariable
     * @return PreviousValue
     */
    public function setOriginVariable(Variable $originVariable): PreviousValue
    {
        $this->originVariable = $originVariable;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return PreviousValue
     */
    public function setValue(?string $value): PreviousValue
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectUri(): string
    {
        return $this->objectUri;
    }

    /**
     * @param string $objectUri
     * @return PreviousValue
     */
    public function setObjectUri(string $objectUri): PreviousValue
    {
        $this->objectUri = $objectUri;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDate(): ?DateTime
    {
        return $this->date;
    }

    /**
     * @param DateTime|null $date
     * @return PreviousValue
     */
    public function setDate(?DateTime $date): PreviousValue
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return StateCode|null
     */
    public function getState(): ?StateCode
    {
        return $this->state;
    }

    /**
     * @param StateCode|null $state
     * @return PreviousValue
     */
    public function setState(?StateCode $state): PreviousValue
    {
        $this->state = $state;
        return $this;
    }
}
