<?php

namespace Webapp\Core\Entity\Fusion;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\ApiOperation\FusionDataEntriesOperation;
use Webapp\Core\Entity\AbstractVariable;
use Webapp\Core\Entity\FieldMeasure;
use Webapp\Core\Entity\Platform;
use Webapp\Core\Entity\ProjectData;

/**
 * Class DataEntryFusion.
 *
 * @ApiResource(
 *     collectionOperations={
 *          "post"={
 *              "controller"=FusionDataEntriesOperation::class,
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Fusion one or more dataEntries",
 *                  "description": "Create a new data entry by merging multiple dataEntries"
 *              },
 *              "normalization_context"={"groups"={"fusion_result"}}
 *          },
 *     },
 *     itemOperations={
 *     "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }}
 * )
 *
 */
class DataEntryFusion
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var ProjectData[]
     */
    private array $orderedDefaultProjectDatasIris;

    /**
     * @var string[]
     */
    private array $selectedVariableIris;

    /**
     * @var array
     */
    private array $specificOrderForItem;

    /**
     * @var ProjectData|null
     * @Groups("fusion_result")
     */
    private ?ProjectData $result;

    /**
     * @var array<array<FieldMeasure>>
     * @Groups("fusion_result")
     */
    private ?array $conflicts;

    /**
     * @var array<FieldMeasure>
     */
    private ?array $mergePriority;

    public function __construct()
    {
        $this->conflicts = [];
        $this->mergePriority = [];
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return DataEntryFusion
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return ProjectData[]
     */
    public function getOrderedDefaultProjectDatasIris(): array
    {
        return $this->orderedDefaultProjectDatasIris;
    }

    /**
     * @param ProjectData[] $orderedDefaultProjectDatasIris
     * @return DataEntryFusion
     */
    public function setOrderedDefaultProjectDatasIris(array $orderedDefaultProjectDatasIris): DataEntryFusion
    {
        $this->orderedDefaultProjectDatasIris = $orderedDefaultProjectDatasIris;
        return $this;
    }

    /**
     * @return AbstractVariable[]
     */
    public function getSelectedVariableIris(): array
    {
        return $this->selectedVariableIris;
    }

    /**
     * @param AbstractVariable[] $selectedVariableIris
     * @return DataEntryFusion
     */
    public function setSelectedVariableIris(array $selectedVariableIris): DataEntryFusion
    {
        $this->selectedVariableIris = $selectedVariableIris;
        return $this;
    }

    /**
     * @return array
     */
    public function getSpecificOrderForItem(): array
    {
        return $this->specificOrderForItem;
    }

    /**
     * @param array $specificOrderForItem
     * @return DataEntryFusion
     */
    public function setSpecificOrderForItem(array $specificOrderForItem): DataEntryFusion
    {
        $this->specificOrderForItem = $specificOrderForItem;
        return $this;
    }

    /**
     * @return ProjectData|null
     */
    public function getResult(): ?ProjectData
    {
        return $this->result;
    }

    /**
     * @param ProjectData|null $result
     * @return DataEntryFusion
     */
    public function setResult(?ProjectData $result): DataEntryFusion
    {
        $this->result = $result;
        return $this;
    }

    /**
     * @return Platform
     * @Groups("fusion_result")
     */
    public function getPlatform(): Platform
    {
        return $this->orderedDefaultProjectDatasIris[0]->getProject()->getPlatform();
    }

    /**
     * @return FieldMeasure[][]
     */
    public function getConflicts(): ?array
    {
        return $this->conflicts;
    }

    /**
     * @param FieldMeasure[][] $conflicts
     * @return DataEntryFusion
     */
    public function setConflicts(?array $conflicts): DataEntryFusion
    {
        $this->conflicts = $conflicts;
        return $this;
    }

    /**
     * @return FieldMeasure[]
     */
    public function getMergePriority(): ?array
    {
        return $this->mergePriority;
    }

    /**
     * @param FieldMeasure[] $mergePriority
     * @return DataEntryFusion
     */
    public function setMergePriority(?array $mergePriority): DataEntryFusion
    {
        $this->mergePriority = $mergePriority;
        return $this;
    }

}
