<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\ApiOperation\CreateBusinessObjectOperation;
use Webapp\Core\Entity\Block;
use Webapp\Core\Entity\Experiment;
use Webapp\Core\Entity\Individual;
use Webapp\Core\Entity\OezNature;
use Webapp\Core\Entity\SubBlock;
use Webapp\Core\Entity\SurfacicUnitPlot;
use Webapp\Core\Entity\Treatment;
use Webapp\Core\Entity\UnitPlot;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "create"={
 *              "controller"=CreateBusinessObjectOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Create one or more buisness object within the same parent",
 *                  "description": "Fill a rectangle with objects"
 *              },
 *              "normalization_context"={"groups"={"platform_full_view"}}
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class Create
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var UnitPlot | SubBlock | Block | Experiment
     */
    private $parent;

    /**
     * @var Block[]|SubBlock[]|UnitPlot[]|Individual[]|SurfacicUnitPlot[]
     * @Groups({"platform_full_view"})
     */
    private array $createdObjects;

    /**
     * @var Treatment | null
     */
    private ?Treatment $treatment;

    /**
     * @var bool
     */
    private bool $useSubBlock;

    /**
     * @var OezNature|null
     */
    private ?OezNature $nature;

    /**
     * @var int
     */
    private int $x1;

    /**
     * @var int
     */
    private int $x2;

    /**
     * @var int
     */
    private int $y1;

    /**
     * @var int
     */
    private int $y2;

    /**
     * @var string
     */
    private string $pathLevel;

    public function __construct()
    {
        $this->parent = '';
        $this->x1 = 0;
        $this->x2 = 0;
        $this->y1 = 0;
        $this->y2 = 0;
        $this->treatment = null;
        $this->useSubBlock = false;
        $this->pathLevel = '';
        $this->nature = null;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return Create
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Block|Experiment|SubBlock|UnitPlot
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param Block|Experiment|SubBlock|UnitPlot $parent
     * @return Create
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
        return $this;
    }

    /**
     * @return Block[]|SubBlock[]|UnitPlot[]|Individual[]|SurfacicUnitPlot[]
     */
    public function getCreatedObjects(): array
    {
        return $this->createdObjects;
    }

    /**
     * @param Block[]|SubBlock[]|UnitPlot[]|Individual[]|SurfacicUnitPlot[] $createdObjects
     * @return Create
     */
    public function setCreatedObjects(array $createdObjects): Create
    {
        $this->createdObjects = $createdObjects;
        return $this;
    }

    /**
     * @return Treatment|null
     */
    public function getTreatment(): ?Treatment
    {
        return $this->treatment;
    }

    /**
     * @param Treatment|null $treatment
     * @return Create
     */
    public function setTreatment(?Treatment $treatment): Create
    {
        $this->treatment = $treatment;
        return $this;
    }

    /**
     * @return bool
     */
    public function isUseSubBlock(): bool
    {
        return $this->useSubBlock;
    }

    /**
     * @param bool $useSubBlock
     * @return Create
     */
    public function setUseSubBlock(bool $useSubBlock): Create
    {
        $this->useSubBlock = $useSubBlock;
        return $this;
    }

    /**
     * @return int
     */
    public function getX1(): int
    {
        return $this->x1;
    }

    /**
     * @param int $x1
     * @return Create
     */
    public function setX1(int $x1): Create
    {
        $this->x1 = $x1;
        return $this;
    }

    /**
     * @return int
     */
    public function getX2(): int
    {
        return $this->x2;
    }

    /**
     * @param int $x2
     * @return Create
     */
    public function setX2(int $x2): Create
    {
        $this->x2 = $x2;
        return $this;
    }

    /**
     * @return int
     */
    public function getY1(): int
    {
        return $this->y1;
    }

    /**
     * @param int $y1
     * @return Create
     */
    public function setY1(int $y1): Create
    {
        $this->y1 = $y1;
        return $this;
    }

    /**
     * @return int
     */
    public function getY2(): int
    {
        return $this->y2;
    }

    /**
     * @param int $y2
     * @return Create
     */
    public function setY2(int $y2): Create
    {
        $this->y2 = $y2;
        return $this;
    }

    /**
     * @return string
     */
    public function getPathLevel(): string
    {
        return $this->pathLevel;
    }

    /**
     * @param string $pathLevel
     * @return Create
     */
    public function setPathLevel(string $pathLevel): Create
    {
        $this->pathLevel = $pathLevel;
        return $this;
    }

    /**
     * @return OezNature|null
     */
    public function getNature(): ?OezNature
    {
        return $this->nature;
    }

    /**
     * @param OezNature|null $nature
     * @return Create
     */
    public function setNature(?OezNature $nature): Create
    {
        $this->nature = $nature;
        return $this;
    }
}
