<?php

namespace Mobile\Device\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\User;

/**
 * Class Note
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\EntryNoteRepository")
 * @ORM\Table(name="note", schema="adonis")
 */
class EntryNote extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="text", nullable=false, options={"default"=""})
     */
    private $text;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false)
     */
    private $deleted;

    /**
     * @var BusinessObject
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\BusinessObject", inversedBy="notes")
     */
    private $businessObject;

    /**
     * @var DateTime
     *
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $creationDate;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\User")
     */
    private $creator;

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return EntryNote
     */
    public function setText(string $text): EntryNote
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * @param bool $deleted
     * @return EntryNote
     */
    public function setDeleted(bool $deleted): EntryNote
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return BusinessObject
     */
    public function getBusinessObject(): BusinessObject
    {
        return $this->businessObject;
    }

    /**
     * @param BusinessObject $businessObject
     * @return EntryNote
     */
    public function setBusinessObject(BusinessObject $businessObject): EntryNote
    {
        $this->businessObject = $businessObject;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getCreationDate(): DateTime
    {
        return $this->creationDate;
    }

    /**
     * @param DateTime $creationDate
     * @return EntryNote
     */
    public function setCreationDate(DateTime $creationDate): EntryNote
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return User
     */
    public function getCreator(): User
    {
        return $this->creator;
    }

    /**
     * @param User $creator
     * @return EntryNote
     */
    public function setCreator(User $creator): EntryNote
    {
        $this->creator = $creator;
        return $this;
    }
}
