<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Measure\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class GeneratedField.
 *
 * @ORM\Entity()
 * @ORM\Table(name="field_generation", schema="adonis")
 */
class GeneratedField extends IdentifiedEntity
{
    /**
     * @var FormField
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\FormField", inversedBy="generatedFields")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $formField;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     */
    private $index;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    private $prefix;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean")
     */
    private $numeralIncrement;

    /**
     * @var Collection<array-key, FormField>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Measure\Entity\FormField", mappedBy="generatedField", cascade={"persist", "remove", "detach"})
     */
    private $formFields;

    /**
     * GeneratedField constructor.
     */
    public function __construct()
    {
        $this->formFields = new ArrayCollection();
    }

    /**
     * @return FormField
     */
    public function getFormField(): FormField
    {
        return $this->formField;
    }

    /**
     * @param FormField $formField
     * @return GeneratedField
     */
    public function setFormField(FormField $formField): GeneratedField
    {
        $this->formField = $formField;
        return $this;
    }

    /**
     * @return int
     */
    public function getIndex(): int
    {
        return $this->index;
    }

    /**
     * @param int $index
     * @return GeneratedField
     */
    public function setIndex(int $index): GeneratedField
    {
        $this->index = $index;
        return $this;
    }

    /**
     * @return string
     */
    public function getPrefix(): string
    {
        return $this->prefix;
    }

    /**
     * @param string $prefix
     * @return GeneratedField
     */
    public function setPrefix(string $prefix): GeneratedField
    {
        $this->prefix = $prefix;
        return $this;
    }

    /**
     * @return bool
     */
    public function isNumeralIncrement(): bool
    {
        return $this->numeralIncrement;
    }

    /**
     * @param bool $numeralIncrement
     * @return GeneratedField
     */
    public function setNumeralIncrement(bool $numeralIncrement): GeneratedField
    {
        $this->numeralIncrement = $numeralIncrement;
        return $this;
    }

    /**
     * @return Collection
     */
    public function getFormFields(): Collection
    {
        return $this->formFields;
    }

    /**
     * @param FormField $formField
     *
     * @return GeneratedField
     */
    public function addFormField(FormField $formField): GeneratedField
    {
        if (!$this->formFields->contains($formField)) {
            $this->formFields->add($formField);
            $formField->setGeneratedField($this);
        }
        return $this;
    }

    /**
     * @param FormField $formField
     *
     * @return GeneratedField
     */
    public function removeFormField(FormField $formField): GeneratedField
    {
        if ($this->formFields->contains($formField)) {
            $this->formFields->removeElement($formField);
            $formField->setGeneratedField(null);
        }
        return $this;
    }
}
