<?php


namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Mobile\Project\Entity\DataEntryProject;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class RequiredAnnotation
 *
 * @ORM\Entity()
 * @ORM\Table(name="required_annotation", schema="adonis")
 */
class RequiredAnnotation extends IdentifiedEntity
{
    /**
     * @var string
     * @ORM\Column(type="string")
     */
    private $pathLevel;

    /**
     * @var int
     * @ORM\Column(type="integer")
     */
    private $type;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    private $comment;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private $active;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     */
    private $askWhenEntering;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    private $buisnessObjects;

    /**
     * @var DataEntryProject
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="requiredAnnotations")
     */
    private $dataEntryProject;

    /**
     * @var string[]
     *
     * @ORM\Column(type="array", nullable=false)
     */
    private $category;

    /**
     * @var string[]
     *
     * @ORM\Column(type="array", nullable=false)
     */
    private $keywords;

    public function __construct()
    {
        $this->keywords = [];
        $this->category = [];
    }

    /**
     * @return string
     */
    public function getPathLevel(): string
    {
        return $this->pathLevel;
    }

    /**
     * @param string $pathLevel
     * @return RequiredAnnotation
     */
    public function setPathLevel(string $pathLevel): RequiredAnnotation
    {
        $this->pathLevel = $pathLevel;
        return $this;
    }

    /**
     * @return int
     */
    public function getType(): int
    {
        return $this->type;
    }

    /**
     * @param int $type
     * @return RequiredAnnotation
     */
    public function setType(int $type): RequiredAnnotation
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getComment(): string
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     * @return RequiredAnnotation
     */
    public function setComment(string $comment): RequiredAnnotation
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @param bool $active
     * @return RequiredAnnotation
     */
    public function setActive(bool $active): RequiredAnnotation
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAskWhenEntering(): bool
    {
        return $this->askWhenEntering;
    }

    /**
     * @param bool $askWhenEntering
     * @return RequiredAnnotation
     */
    public function setAskWhenEntering(bool $askWhenEntering): RequiredAnnotation
    {
        $this->askWhenEntering = $askWhenEntering;
        return $this;
    }

    /**
     * @return string
     */
    public function getBuisnessObjects(): string
    {
        return $this->buisnessObjects;
    }

    /**
     * @param string $buisnessObjects
     * @return RequiredAnnotation
     */
    public function setBuisnessObjects(string $buisnessObjects): RequiredAnnotation
    {
        $this->buisnessObjects = $buisnessObjects;
        return $this;
    }

    /**
     * @return DataEntryProject
     */
    public function getDataEntryProject(): DataEntryProject
    {
        return $this->dataEntryProject;
    }

    /**
     * @param DataEntryProject $dataEntryProject
     * @return RequiredAnnotation
     */
    public function setDataEntryProject(DataEntryProject $dataEntryProject): RequiredAnnotation
    {
        $this->dataEntryProject = $dataEntryProject;
        return $this;
    }

    /**
     * @return string[]
     */
    public function getCategory(): array
    {
        return $this->category;
    }

    /**
     * @param string[] $category
     * @return RequiredAnnotation
     */
    public function setCategory(array $category): RequiredAnnotation
    {
        $this->category = $category;
        return $this;
    }

    public function addCategory(string $category): void
    {
        if (!in_array($category, $this->category)) {
            $this->category[] = $category;
        }
    }

    /**
     * @return string[]
     */
    public function getKeywords(): array
    {
        return $this->keywords;
    }

    /**
     * @param string[] $keywords
     * @return RequiredAnnotation
     */
    public function setKeywords(array $keywords): RequiredAnnotation
    {
        $this->keywords = $keywords;
        return $this;
    }

    /**
     * @param string $keyword
     */
    public function addKeyword(string $keyword): void
    {
        if (!in_array($keyword, $this->keywords)) {
            $this->keywords[] = $keyword;
        }
    }
}
