<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Mobile\Project\Entity\DataEntryProject;

/**
 * Class UniqueVariable.
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\UniqueVariableRepository")
 * @ORM\Table(name="variable_unique", schema="adonis")
 */
class UniqueVariable extends Variable
{
    /**
     * @var DataEntryProject|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="uniqueVariables")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    protected $project;

    /**
     * @var DataEntryProject|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="connectedUniqueVariables")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    protected $connectedDataEntryProject;

    /**
     * @var GeneratorVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\GeneratorVariable", inversedBy="uniqueVariables")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    protected $generatorVariable;

    /**
     * @var Material | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Material", inversedBy="uniqueVariables", cascade={"persist", "remove", "detach"})
     */
    protected $material;

    /**
     * @var ValueHintList|null
     *
     * @ORM\OneToOne(targetEntity="Mobile\Measure\Entity\Variable\ValueHintList", mappedBy="variable", cascade={"persist","remove"}, orphanRemoval=true)
     */
    private $valueHintList;

    /**
     * @param Variable $variable
     */
    public function merge(Variable $variable)
    {
        parent::merge($variable);
        if ($variable instanceof UniqueVariable) {
            $this->setValueHintList($variable->getValueHintList());
            $variable->setValueHintList(null);
        }
    }

    /**
     * @return ValueHintList|null
     */
    public function getValueHintList(): ?ValueHintList
    {
        return $this->valueHintList;
    }

    /**
     * @param ValueHintList|null $valueHintList
     * @return UniqueVariable
     */
    public function setValueHintList(?ValueHintList $valueHintList): UniqueVariable
    {
        if ($this->valueHintList !== null) {
            $this->valueHintList->setVariable(null);
        }
        $this->valueHintList = $valueHintList;
        if ($valueHintList !== null) {
            $valueHintList->setVariable($this);
        }
        return $this;
    }
}
