<?php

namespace Webapp\Core\Entity;

use DateTime;

/**
 * interface BusinessObject
 * @package Webapp\Core\Entity
 *
 */
interface BusinessObject
{
    /**
     * @return BusinessObject|null
     */
    function parent(): ?BusinessObject;

    /**
     * @return array<BusinessObject>
     */
    function children(): array;

    function setGraphicallyDeletedAt(DateTime $deletedAt = null);

    function getGraphicallyDeletedAt();
}
