<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class ValueListItem
 * @package Webapp\Core\Entity
 *
 * @ORM\Entity()
 * @ORM\Table(name="value_list_item", schema="webapp")
 */
class ValueListItem extends IdentifiedEntity
{
    /**
     * @var string
     * @Groups({"simple_variable_get", "simple_variable_post"})
     * @ORM\Column(type="string")
     */
    private string $name;

    /**
     * @var ValueList|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\ValueList", inversedBy="values")
     */
    private ?ValueList $list;

    public function __construct($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ValueListItem
     */
    public function setName(string $name): ValueListItem
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return ValueList
     */
    public function getList(): ValueList
    {
        return $this->list;
    }

    /**
     * @param ValueList|null $list
     * @return ValueListItem
     */
    public function setList(?ValueList $list): ValueListItem
    {
        $this->list = $list;
        return $this;
    }

}
