<?php

namespace Webapp\FileManagement\Entity\Base;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\SoftDeleteable\Traits\SoftDeleteableEntity;
use Shared\FileManagement\Entity\UserLinkedJob;
use Symfony\Component\Serializer\Annotation\Groups;
use Vich\UploaderBundle\Mapping\Annotation as Vich;
use Webapp\FileManagement\Service\ProjectFileInterface;

/**
 * Class UserLinkedFileJob
 * @package Webapp\FileManagement\Entity
 *
 * @ORM\MappedSuperclass()
 * @Gedmo\SoftDeleteable()
 * @Vich\Uploadable()
 */
abstract class UserLinkedFileJob extends UserLinkedJob implements ProjectFileInterface
{

    use SoftDeleteableEntity;
    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @var string
     *
     * @Groups({"user_linked_file_job_read"})
     *
     * @ORM\Column(type="string")
     */
    protected $status;

    /**
     * @var string|null
     *
     * @ORM\Column(nullable=true)
     */
    protected $filePath;

    /**
     * @Vich\UploadableField(mapping="project_file", fileNameProperty="filePath")
     */
    protected $file;

    /**
     * @var string|null
     *
     * @Groups({"user_linked_file_job_read"})
     */
    protected $contentUrl;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     *
     */
    protected $uniqDirectoryName;

    /**
     * @var DateTime
     *
     * @Groups({"user_linked_file_job_read"})
     *
     * @ORM\Column(type="datetime")
     */
    protected $uploadDate;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return static
     */
    public function setName(string $name): self
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * @param mixed $file
     * @return static
     */
    public function setFile($file): self
    {
        $this->file = $file;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilePath(): ?string
    {
        return $this->filePath;
    }

    /**
     * @param string|null $filePath
     * @return static
     */
    public function setFilePath(?string $filePath): self
    {
        $this->filePath = $filePath;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getContentUrl(): ?string
    {
        return $this->contentUrl;
    }

    /**
     * @param string|null $contentUrl
     * @return static
     */
    public function setContentUrl(?string $contentUrl): self
    {
        $this->contentUrl = $contentUrl;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUniqDirectoryName(): ?string
    {
        return $this->uniqDirectoryName;
    }

    /**
     * @param string|null $uniqDirectoryName
     * @return static
     */
    public function setUniqDirectoryName(?string $uniqDirectoryName): self
    {
        $this->uniqDirectoryName = $uniqDirectoryName;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getUploadDate(): DateTime
    {
        return $this->uploadDate;
    }

    /**
     * @param DateTime $uploadDate
     * @return static
     */
    public function setUploadDate(DateTime $uploadDate): self
    {
        $this->uploadDate = $uploadDate;
        return $this;
    }
}
