<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = '__root__';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'api-platform/core' => 'v2.6.8@ff3aab5b196709c721960c0bb4f1d52759af737d',
  'aws/aws-crt-php' => 'v1.2.5@0ea1f04ec5aa9f049f97e012d1ed63b76834a31b',
  'aws/aws-sdk-php' => '3.314.3@c9e8a31cfa07f47b7ab9ecc741845a3a9d50fc61',
  'behat/transliterator' => 'v1.5.0@baac5873bac3749887d28ab68e2f74db3a4408af',
  'brick/geo' => '0.7.2@725789f7c090235e230b9a666acf59e0fc7f8e24',
  'cocur/background-process' => 'v0.7@9ae2902922f02ec5544d723756758eb7304c6869',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'doctrine/annotations' => '1.14.3@fb0d71a7393298a7b232cbf4c8b1f73f3ec3d5af',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '1.8.0@2b44dd4cbca8b5744327de78bafef5945c7e7b5e',
  'doctrine/common' => '3.4.4@0aad4b7ab7ce8c6602dfbb1e1a24581275fb9d1a',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => '1.1.3@dfbaa3c2d2e9a9df1118213f3b8b0c597bb99fab',
  'doctrine/doctrine-bundle' => '2.7.2@22d53b2c5ad03929628fb4a928b01135585b7179',
  'doctrine/doctrine-migrations-bundle' => '2.2.3@0a081b55a88259a887af7be654743a8c5f703e99',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.19.5@94986af28452da42a46a4489d1c958a2e5d710e5',
  'doctrine/persistence' => '3.3.2@477da35bd0255e032826f440b94b3e37f2d56f42',
  'doctrine/sql-formatter' => '1.3.0@3447381095d32a171fe3a58323749f44dbb5ac7d',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'fig/link-util' => '1.1.2@5d7b8d04ed3393b4b59968ca1e906fb7186d81e8',
  'friendsofphp/proxy-manager-lts' => 'v1.0.18@2c8a6cffc3220e99352ad958fe7cf06bf6f7690f',
  'gedmo/doctrine-extensions' => 'v3.13.0@291d0c527d2dc9ee07b888c9a4e2a179893f08ab',
  'gesdinet/jwt-refresh-token-bundle' => 'v1.3.0@83d687cc461b4bdae9ffc6efda97464093cae739',
  'guzzlehttp/guzzle' => '7.8.1@41042bc7ab002487b876a0683fc8dce04ddce104',
  'guzzlehttp/promises' => '2.0.2@bbff78d96034045e58e13dedd6ad91b5d1253223',
  'guzzlehttp/psr7' => '2.6.2@45b30f99ac27b5ca93cb4831afe16285f57b8221',
  'jms/metadata' => '2.8.0@7ca240dcac0c655eb15933ee55736ccd2ea0d7a6',
  'knplabs/gaufrette' => 'v0.10.0@ef5ec9d72c06d21febfa09b36d5c3d8e3af9cf8b',
  'knplabs/knp-gaufrette-bundle' => 'v0.7.2@9cf8706e9f01d4a7ee5013261a10768efdfebb0f',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-eventmanager' => '3.5.0@41f7209428f37cab9573365e361f4078209aaafa',
  'laminas/laminas-zendframework-bridge' => '1.6.1@e112dd2c099f4f6142c16fc65fda89a638e06885',
  'lcobucci/clock' => '2.0.0@353d83fe2e6ae95745b16b3d911813df6a05bfb3',
  'lcobucci/jwt' => '4.3.0@4d7de2fe0d51a96418c0d04004986e410e87f6b4',
  'lexik/jwt-authentication-bundle' => 'v2.21.0@d57159da3f572b42ab609630edb6e27d71b37eca',
  'mmucklo/queue-bundle' => '6.7.0@11481017c777fd18930d3e3f5d26f5f07e9f4d4a',
  'monolog/monolog' => '2.9.3@a30bfe2e142720dfa990d0a7e573997f5d884215',
  'mtdowling/jmespath.php' => '2.7.0@bbb69a935c2cbb0c03d7f481a238027430f6440b',
  'namshi/jose' => '7.2.3@89a24d7eb3040e285dd5925fcad992378b82bcff',
  'nelmio/cors-bundle' => '2.4.0@78fcdb91f76b080a1008133def9c7f613833933d',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.4.1@9d07b3f7fdcf5efec5d1609cba3c19c5ea2bdc9c',
  'phpdocumentor/type-resolver' => '1.8.2@153ae662783729388a584b4361f2545e4d841e3c',
  'phpstan/phpdoc-parser' => '1.29.1@fcaefacf2d5c417e928405b71b400d4ce10daaf4',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'stof/doctrine-extensions-bundle' => 'v1.10.1@299d5333ce83941069852be36b949abbc776bf1d',
  'symfony/apache-pack' => 'v1.0.1@3aa5818d73ad2551281fc58a75afd9ca82622e6c',
  'symfony/asset' => 'v5.4.40@e5aa241b4914257164b39c3c2678b2c41b7671e3',
  'symfony/cache' => 'v5.4.40@89005bc368ca02ed0433c592e4d27670d0844a66',
  'symfony/cache-contracts' => 'v2.5.3@fee6db04d913094e2fb55ff8e7db5685a8134463',
  'symfony/config' => 'v5.4.40@d4e1db78421163b98dd9971d247fd0df4a57ee5e',
  'symfony/console' => 'v5.4.40@aa73115c0c24220b523625bfcfa655d7d73662dd',
  'symfony/dependency-injection' => 'v5.4.40@408b33326496030c201b8051b003e9e8cdb2efc9',
  'symfony/deprecation-contracts' => 'v2.5.3@80d075412b557d41002320b96a096ca65aa2c98d',
  'symfony/doctrine-bridge' => 'v5.4.40@d8ab3a46043e2ef314a8b93250d26b07c55d9564',
  'symfony/dotenv' => 'v5.4.40@3052dbf22f71e47f6ef7a5efa6aaedfe871ba35d',
  'symfony/error-handler' => 'v5.4.40@c6c8f965a87b22d5005a7806783c7f10ae7e58cd',
  'symfony/event-dispatcher' => 'v5.4.40@a54e2a8a114065f31020d6a89ede83e34c3b27a4',
  'symfony/event-dispatcher-contracts' => 'v2.5.3@540f4c73e87fd0c71ca44a6aa305d024ac68cb73',
  'symfony/expression-language' => 'v5.4.40@77670d1e74086dc8d941a18f97097bbf988f2840',
  'symfony/filesystem' => 'v5.4.40@26dd9912df6940810ea00f8f53ad48d6a3424995',
  'symfony/finder' => 'v5.4.40@f51cff4687547641c7d8180d74932ab40b2205ce',
  'symfony/flex' => 'v1.21.6@06b58a5e5b4c6528fb12e0fac5fea0db3f1e7ae8',
  'symfony/form' => 'v5.4.40@ff45013def0a3a692e84010095e8ee5fe9a9fa43',
  'symfony/framework-bundle' => 'v5.4.40@603090d8327e279bd233d5ce42a1ed89bc91612f',
  'symfony/http-foundation' => 'v5.4.40@cf4893ca4eca3fac4ae06da1590afdbbb4217847',
  'symfony/http-kernel' => 'v5.4.40@3ad03183c6985adc2eece16f239f8cfe1c4ccbe3',
  'symfony/intl' => 'v5.4.40@75482b3b0aadc7f652d99b4f543b1d21f6562ff4',
  'symfony/ldap' => 'v5.4.40@a0418790cbd4c70789059dbf57c111f12db3c1dc',
  'symfony/mailer' => 'v5.4.40@54fec5a552238d071502facd85c34af83a20dc38',
  'symfony/mime' => 'v5.4.40@8c6dc1fb0b1f990aa15086abcde66dbde3a9bdad',
  'symfony/monolog-bridge' => 'v5.4.40@ac6e0bf2a275e017c1dedd54dd0f1fbf252a9351',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/options-resolver' => 'v5.4.40@bd1afbde6613a8d6b956115e0e14b196191fd0c4',
  'symfony/password-hasher' => 'v5.4.40@21b98178ab2024e6c7d8ab72cca9ba16015c6093',
  'symfony/polyfill-intl-grapheme' => 'v1.29.0@32a9da87d7b3245e09ac426c83d334ae9f06f80f',
  'symfony/polyfill-intl-icu' => 'v1.29.0@07094a28851a49107f3ab4f9120ca2975a64b6e1',
  'symfony/polyfill-intl-idn' => 'v1.29.0@a287ed7475f85bf6f61890146edbc932c0fff919',
  'symfony/polyfill-intl-normalizer' => 'v1.29.0@bc45c394692b948b4d383a08d7753968bed9a83d',
  'symfony/polyfill-mbstring' => 'v1.29.0@9773676c8a1bb1f8d4340a62efe641cf76eda7ec',
  'symfony/polyfill-php72' => 'v1.29.0@861391a8da9a04cbad2d232ddd9e4893220d6e25',
  'symfony/polyfill-php73' => 'v1.29.0@21bd091060673a1177ae842c0ef8fe30893114d2',
  'symfony/polyfill-php80' => 'v1.29.0@87b68208d5c1188808dd7839ee1e6c8ec3b02f1b',
  'symfony/polyfill-php81' => 'v1.29.0@c565ad1e63f30e7477fc40738343c62b40bc672d',
  'symfony/process' => 'v5.4.40@deedcb3bb4669cae2148bc920eafd2b16dc7c046',
  'symfony/property-access' => 'v5.4.40@6e4834145c2231b34eafabe440aaac478a95b456',
  'symfony/property-info' => 'v5.4.40@b999cc2450f81d4527c97c217260dc372601a95d',
  'symfony/proxy-manager-bridge' => 'v5.4.40@2ebc25e0174a6a244f7edada5a498f9728dc0d29',
  'symfony/routing' => 'v5.4.40@6df1dd8b306649303267a760699cf04cf39b1f7b',
  'symfony/security-bundle' => 'v5.4.40@d977faacbaf0e6e551443b3b6c14315be6e7fe57',
  'symfony/security-core' => 'v5.4.40@f8b49ac9b4b61fca958e6163f3cbb69d8c7d703a',
  'symfony/security-csrf' => 'v5.4.40@9058d522c1c33d7ba13f4b3c79555cc2c4c16028',
  'symfony/security-guard' => 'v5.4.40@d930fd327c290f451c9d8dd7889169195d4484e9',
  'symfony/security-http' => 'v5.4.40@71948200354880137f719133d5a84927e3a140fb',
  'symfony/serializer' => 'v5.4.40@ef0be2b53d4424ad70075eeab74fb61184952ce9',
  'symfony/service-contracts' => 'v2.5.3@a2329596ddc8fd568900e3fc76cba42489ecc7f3',
  'symfony/stopwatch' => 'v5.4.40@0e9daf3b7c805c747638b2cc48f1649e594f9625',
  'symfony/string' => 'v5.4.40@142877285aa974a6f7685e292ab5ba9aae86b143',
  'symfony/translation' => 'v5.4.40@bb51d7f183756d1ac03f50ea47dc5726518cc7e8',
  'symfony/translation-contracts' => 'v2.5.3@b0073a77ac0b7ea55131020e87b1e3af540f4664',
  'symfony/twig-bridge' => 'v5.4.40@b982cfa2d15058d2642ca4cf7edab495d6dac707',
  'symfony/twig-bundle' => 'v5.4.40@997c002735c88b50a6325cca8ecf3d8723902666',
  'symfony/validator' => 'v5.4.40@d536c47c62c7739f9956727d6e5d94983ed77cdb',
  'symfony/var-dumper' => 'v5.4.40@af8868a6e9d6082dfca11f1a1f205ae93a8b6d93',
  'symfony/var-exporter' => 'v5.4.40@6a13d37336d512927986e09f19a4bed24178baa6',
  'symfony/web-link' => 'v5.4.40@2615fe9ec22e210f06826d8ef4c32249ff9bfc01',
  'symfony/webpack-encore-bundle' => 'v1.17.2@471ebbc03072dad6e31840dc317bc634a32785f5',
  'symfony/yaml' => 'v5.4.40@81cad0ceab3d61fe14fe941ff18a230ac9c80f83',
  'twig/extra-bundle' => 'v3.10.0@cdc6e23aeb7f4953c1039568c3439aab60c56454',
  'twig/twig' => 'v3.10.3@67f29781ffafa520b0bbfbd8384674b42db04572',
  'vich/uploader-bundle' => '1.23.1@7d20347fc92243ab8e261c0b6196c25b77c579f8',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'amphp/amp' => 'v2.6.4@ded3d9be08f526089eb7ee8d9f16a9768f9dec2d',
  'amphp/byte-stream' => 'v1.8.2@4f0e968ba3798a423730f567b1b50d3441c16ddc',
  'composer/pcre' => '3.1.4@04229f163664973f68f38f6f73d917799168ef24',
  'composer/semver' => '3.4.0@35e8d0af4486141bc745f23a29cc2091eb624a32',
  'composer/xdebug-handler' => '3.0.5@6c1925561632e83d60a44492e0b344cf48ab85ef',
  'deployer/deployer' => 'v6.9.0@c4380effdc9f6d9c6ae549bb76f0a22bcb1d31d2',
  'deployer/phar-update' => 'v2.2.0@9ad07422f2cd43a1382ee8e134bdcd3a374848e3',
  'deployer/recipes' => '6.2.2@84b3229c518c094a950e1fe785b7b8f9598770fe',
  'dnoegel/php-xdg-base-dir' => 'v0.1.1@8f8a6e48c5ecb0f991c2fdcf5f154a47d85f9ffd',
  'doctrine/data-fixtures' => '1.6.7@ae4e845decbe177348fdbecd04331f4fb96aa301',
  'doctrine/doctrine-fixtures-bundle' => '3.4.5@5988484f79362cd7d06564bd11be7ce622e08c87',
  'felixfbecker/advanced-json-rpc' => 'v3.2.1@b5f37dbff9a8ad360ca341f3240dc1c168b45447',
  'felixfbecker/language-server-protocol' => 'v1.5.2@6e82196ffd7c62f7794d778ca52b69feec9f2842',
  'fidry/cpu-core-counter' => '1.1.0@f92996c4d5c1a696a6a970e20f7c4216200fcc42',
  'myclabs/deep-copy' => '1.12.0@3a6b9a42cd8f8771bd4295d13e1423fa7f3d942c',
  'netresearch/jsonmapper' => 'v4.4.1@132c75c7dd83e45353ebb9c6c9f591952995bbf0',
  'nikic/php-parser' => 'v4.19.1@4e1b88d21c69391150ace211e9eaf05810858d0b',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.31@48c34b5d8d983006bd2adc2d0de92963b9155965',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.19@a1a54a473501ef4cdeaae4e06891674114d79db8',
  'pimple/pimple' => 'v3.5.0@a94b3a4db7fb774b3d78dad2315ddc07629e1bed',
  'psalm/plugin-symfony' => 'v5.1.0@f23ec3439743fb24f5c1101e52d032f23d5befa6',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'spatie/array-to-xml' => '2.17.1@5cbec9c6ab17e320c58a259f0cebe88bde4a7c46',
  'symfony/browser-kit' => 'v5.4.40@92c8ba1e5ee12d07120744c90898516132b4e58b',
  'symfony/css-selector' => 'v5.4.40@ea43887e9afd2029509662d4f95e8b5ef6fc9bbb',
  'symfony/debug-bundle' => 'v5.4.40@177f79296705823eee0d7dd79773f3a9df884fe0',
  'symfony/dom-crawler' => 'v5.4.40@2ad469c3e07fdba677b278d0e266071a51aa0dac',
  'symfony/http-client' => 'v5.4.40@970a4d5a3393be3ba987b91a018e98ee332db63b',
  'symfony/http-client-contracts' => 'v2.5.3@e5cc97c2b4a4db0ba26bebc154f1426e3fd1d2f1',
  'symfony/maker-bundle' => 'v1.43.0@e3f9a1d9e0f4968f68454403e820dffc7db38a59',
  'symfony/phpunit-bridge' => 'v5.4.40@875f7030e8998d4d31be8f3f8669c66e68d6be04',
  'symfony/web-profiler-bundle' => 'v5.4.40@a29669617c4e63785f363571a190a706b9022890',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'vimeo/psalm' => '5.24.0@462c80e31c34e58cc4f750c656be3927e80e550e',
  'paragonie/random_compat' => '2.*@',
  'symfony/polyfill-ctype' => '*@',
  'symfony/polyfill-iconv' => '*@',
  'symfony/polyfill-php71' => '*@',
  'symfony/polyfill-php70' => '*@',
  'symfony/polyfill-php56' => '*@',
  '__root__' => '1.0.0+no-version-set@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
