<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Device\Dto;

/**
 * Class PositionableInput.
 */
abstract class PositionableInput extends EvaluableInput
{
    /**
     * @var int
     */
    private $x;

    /**
     * @var int
     */
    private $y;

    /**
     * @var int|null
     */
    private $stateCode;

    /**
     * @var string|null
     */
    private $ident;

    /**
     * @var AnomalyInput|null
     */
    private $anomaly;

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return PositionableInput
     */
    public function setX(int $x): PositionableInput
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return PositionableInput
     */
    public function setY(int $y): PositionableInput
    {
        $this->y = $y;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getStateCode(): ?int
    {
        return $this->stateCode;
    }

    /**
     * @param int|null $stateCode
     * @return PositionableInput
     */
    public function setStateCode(?int $stateCode): PositionableInput
    {
        $this->stateCode = $stateCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIdent(): ?string
    {
        return $this->ident;
    }

    /**
     * @param string|null $ident
     * @return PositionableInput
     */
    public function setIdent(?string $ident): PositionableInput
    {
        $this->ident = $ident;
        return $this;
    }

    /**
     * @return AnomalyInput|null
     */
    public function getAnomaly(): ?AnomalyInput
    {
        return $this->anomaly;
    }

    /**
     * @param AnomalyInput|null $anomaly
     * @return PositionableInput
     */
    public function setAnomaly(?AnomalyInput $anomaly): PositionableInput
    {
        $this->anomaly = $anomaly;
        return $this;
    }

}
