<?php

namespace Mobile\Device\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class Block.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\BlockRepository")
 * @ORM\Table(name="block", schema="adonis")
 */
class Block extends BusinessObject
{
    /**
     * @var Device
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Device", inversedBy="blocks")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $device;

    /**
     * @var Collection<array-key, SubBlock>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\SubBlock", mappedBy="block", cascade={"persist", "remove", "detach"})
     */
    private $subBlocks;

    /**
     * @var Collection<array-key, UnitParcel>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\UnitParcel", mappedBy="block", cascade={"persist", "remove", "detach"})
     */
    private $unitParcels;
    /**
     * @var Collection<array-key, OutExperimentationZone>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\OutExperimentationZone", mappedBy="block", cascade={"persist", "remove", "detach"})
     */
    private $outExperimentationZones;

    /**
     * Block constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->subBlocks = new ArrayCollection();
        $this->unitParcels = new ArrayCollection();
        $this->outExperimentationZones = new ArrayCollection();
    }

    /**
     * @return Device
     */
    public function getDevice(): Device
    {
        return $this->device;
    }

    /**
     * @param Device $device
     * @return Block
     */
    public function setDevice(Device $device): Block
    {
        $this->device = $device;
        return $this;
    }

    /**
     * @return Collection<array-key, SubBlock>
     */
    public function getSubBlocks(): Collection
    {
        return $this->subBlocks;
    }

    /**
     * @param SubBlock $subBlock
     */
    public function addSubBlock(SubBlock $subBlock): void
    {
        if (!$this->subBlocks->contains($subBlock)) {
            $subBlock->setBlock($this);
            $this->subBlocks->add($subBlock);
        }
    }

    /**
     * @param SubBlock $subBlock
     */
    public function removeSubBlock(SubBlock $subBlock): void
    {
        if ($this->subBlocks->contains($subBlock)) {
            $this->subBlocks->removeElement($subBlock);
        }
    }

    /**
     * @return Collection<array-key, UnitParcel>
     */
    public function getUnitParcels(): Collection
    {
        return $this->unitParcels;
    }

    /**
     * @param UnitParcel $pu
     */
    public function addUnitParcel(UnitParcel $pu): void
    {
        if (!$this->unitParcels->contains($pu)) {
            $pu->setBlock($this);
            $pu->setSubBlock(null);
            $this->unitParcels->add($pu);
        }
    }

    /**
     * @param UnitParcel $pu
     */
    public function removeUnitParcel(UnitParcel $pu): void
    {
        if ($this->unitParcels->contains($pu)) {
            $this->unitParcels->removeElement($pu);
        }
    }

    /**
     * @return Collection
     */
    public function getOutExperimentationZones(): Collection
    {
        return $this->outExperimentationZones;
    }

    /**
     * @param Collection $outExperimentationZones
     * @return Block
     */
    public function setOutExperimentationZones(Collection $outExperimentationZones): Block
    {
        $this->outExperimentationZones = $outExperimentationZones;
        return $this;
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function addOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if (!$this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setBlock($this);
            $this->outExperimentationZones->add($outExperimentationZone);
        }
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function removeOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if ($this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setBlock(null);
            $this->outExperimentationZones->removeElement($outExperimentationZone);
        }
    }

    public function parent(): ?BusinessObject
    {
        return $this->getDevice();
    }
}
