<?php

namespace Mobile\Device\Entity;

use Doctrine\ORM\Mapping as ORM;
use Mobile\Project\Entity\NatureZHE;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class outExploitationZone
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\OutExperimentationZoneRepository")
 * @ORM\Table(name="out_experimentation_zone", schema="adonis")
 */
class OutExperimentationZone extends IdentifiedEntity
{
    /**
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $x;

    /**
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $y;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $number;

    /**
     * @var NatureZHE
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\NatureZHE")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $natureZHE;

    /**
     * @var Device | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Device", inversedBy="outExperimentationZones")
     */
    private $device;
    /**
     * @var Block | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Block", inversedBy="outExperimentationZones")
     */
    private $block;
    /**
     * @var SubBlock | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\SubBlock", inversedBy="outExperimentationZones")
     */
    private $subBlock;
    /**
     * @var UnitParcel | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\UnitParcel", inversedBy="outExperimentationZones")
     */
    private $unitParcel;

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return OutExperimentationZone
     */
    public function setX(int $x): OutExperimentationZone
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return OutExperimentationZone
     */
    public function setY(int $y): OutExperimentationZone
    {
        $this->y = $y;
        return $this;

    }

    /**
     * @return string
     */
    public function getNumber(): string
    {
        return $this->number;
    }

    /**
     * @param string $number
     * @return OutExperimentationZone
     */
    public function setNumber(string $number): OutExperimentationZone
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return NatureZHE
     */
    public function getNatureZHE(): NatureZHE
    {
        return $this->natureZHE;
    }

    /**
     * @param NatureZHE $natureZHE
     * @return OutExperimentationZone
     */
    public function setNatureZHE(NatureZHE $natureZHE): OutExperimentationZone
    {
        $this->natureZHE = $natureZHE;
        return $this;
    }

    /**
     * @return Device|null
     */
    public function getDevice(): ?Device
    {
        return $this->device;
    }

    /**
     * @param Device|null $device
     * @return OutExperimentationZone
     */
    public function setDevice(?Device $device): OutExperimentationZone
    {
        $this->device = $device;
        return $this;
    }

    /**
     * @return Block|null
     */
    public function getBlock(): ?Block
    {
        return $this->block;
    }

    /**
     * @param Block|null $block
     * @return OutExperimentationZone
     */
    public function setBlock(?Block $block): OutExperimentationZone
    {
        $this->block = $block;
        return $this;
    }

    /**
     * @return SubBlock|null
     */
    public function getSubBlock(): ?SubBlock
    {
        return $this->subBlock;
    }

    /**
     * @param SubBlock|null $subBlock
     * @return OutExperimentationZone
     */
    public function setSubBlock(?SubBlock $subBlock): OutExperimentationZone
    {
        $this->subBlock = $subBlock;
        return $this;
    }

    /**
     * @return UnitParcel|null
     */
    public function getUnitParcel(): ?UnitParcel
    {
        return $this->unitParcel;
    }

    /**
     * @param UnitParcel|null $unitParcel
     * @return OutExperimentationZone
     */
    public function setUnitParcel(?UnitParcel $unitParcel): OutExperimentationZone
    {
        $this->unitParcel = $unitParcel;
        return $this;
    }

}
