<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Measure\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class Session.
 *
 * @ORM\Entity()
 * @ORM\Table(name="session_data", schema="adonis")
 */
class Session extends IdentifiedEntity
{
    /**
     * @var DataEntry
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\DataEntry", inversedBy="sessions")
     * @ORM\JoinColumn(name="data_entry_id", referencedColumnName="id", nullable=false)
     */
    private $dataEntry;

    /**
     * @var DateTime
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $startedAt;

    /**
     * @var DateTime
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $endedAt;

    /**
     * @var Collection<array-key, FormField>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Measure\Entity\FormField", mappedBy="session", cascade={"persist", "remove", "detach"})
     */
    private $formFields;

    /**
     * Session constructor.
     */
    public function __construct()
    {
        $this->formFields = new ArrayCollection();
    }

    /**
     * @return DataEntry
     */
    public function getDataEntry(): DataEntry
    {
        return $this->dataEntry;
    }

    /**
     * @param DataEntry $dataEntry
     * @return Session
     */
    public function setDataEntry(DataEntry $dataEntry): Session
    {
        $this->dataEntry = $dataEntry;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getStartedAt(): DateTime
    {
        return $this->startedAt;
    }

    /**
     * @param DateTime $startedAt
     * @return Session
     */
    public function setStartedAt(DateTime $startedAt): Session
    {
        $this->startedAt = $startedAt;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getEndedAt(): DateTime
    {
        return $this->endedAt;
    }

    /**
     * @param DateTime $endedAt
     * @return Session
     */
    public function setEndedAt(DateTime $endedAt): Session
    {
        $this->endedAt = $endedAt;
        return $this;
    }

    /**
     * @return Collection<array-key, FormField>
     */
    public function getFormFields(): Collection
    {
        return $this->formFields;
    }

    /**
     * @param FormField $formField
     *
     * @return Session
     */
    public function addFormField(FormField $formField): Session
    {
        if (!$this->formFields->contains($formField)) {
            $this->formFields->add($formField);
            $formField->setSession($this);
        }
        return $this;
    }

    /**
     * @param FormField $formField
     *
     * @return Session
     */
    public function removeFormField(FormField $formField): Session
    {
        if ($this->formFields->contains($formField)) {
            $this->formFields->removeElement($formField);
            $formField->setSession(null);
        }
        return $this;
    }
}
