<?php

namespace Mobile\Measure\Entity\Test\Base;

use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * @ORM\Entity()
 * @ORM\Table(name="test", schema="adonis")
 * @ORM\InheritanceType("JOINED")
 * @ORM\DiscriminatorColumn(name="discr", type="string")
 * @ORM\DiscriminatorMap({
 *     "RangeTest": "Mobile\Measure\Entity\Test\RangeTest",
 *     "GrowthTest": "Mobile\Measure\Entity\Test\GrowthTest",
 *     "PreconditionedCalculation": "Mobile\Measure\Entity\Test\PreconditionedCalculation",
 *     "CombinationTest": "Mobile\Measure\Entity\Test\CombinationTest",
 * })
 */
abstract class Test extends IdentifiedEntity
{
    /**
     * @var Variable
     */
    protected $variable;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false)
     */
    private $active;

    public function __construct()
    {
        $this->name = "";
    }

    /**
     * @return Variable
     */
    public function getVariable(): Variable
    {
        return $this->variable;
    }

    /**
     * @param Variable $variable
     * @return Test
     */
    public function setVariable(Variable $variable): Test
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return string
     */
    public abstract function getTypeTest(): string;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Test
     */
    public function setName(string $name): Test
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @param bool $active
     * @return Test
     */
    public function setActive(bool $active): Test
    {
        $this->active = $active;
        return $this;
    }
}
