<?php

namespace Mobile\Measure\Entity\Test;

use Mobile\Measure\Entity\Test\Base\Test;
use Mobile\Measure\Entity\Variable\Base\Variable;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class GrowthTest.
 *
 * @ORM\Entity()
 * @ORM\Table(name="test_growth", schema="adonis")
 */
class GrowthTest extends Test
{
    const GROWTH_TEST = 'GrowthTest';

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable", inversedBy="growthTests")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    protected $variable;

    /**
     * @var Variable
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Base\Variable")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $comparisonVariable;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $minDiff;

    /**
     * @var float
     *
     * @ORM\Column(type="float", nullable=false)
     */
    private $maxDiff;

    /**
     * @return string
     */
    public function getTypeTest(): string
    {
        return static::GROWTH_TEST;
    }

    /**
     * @return Variable
     */
    public function getComparisonVariable(): Variable
    {
        return $this->comparisonVariable;
    }

    /**
     * @param Variable $comparisonVariable
     * @return GrowthTest
     */
    public function setComparisonVariable(Variable $comparisonVariable): GrowthTest
    {
        $this->comparisonVariable = $comparisonVariable;
        return $this;
    }

    /**
     * @return float
     */
    public function getMinDiff(): float
    {
        return $this->minDiff;
    }

    /**
     * @param float $minDiff
     * @return GrowthTest
     */
    public function setMinDiff(float $minDiff): GrowthTest
    {
        $this->minDiff = $minDiff;
        return $this;
    }

    /**
     * @return float
     */
    public function getMaxDiff(): float
    {
        return $this->maxDiff;
    }

    /**
     * @param float $maxDiff
     * @return GrowthTest
     */
    public function setMaxDiff(float $maxDiff): GrowthTest
    {
        $this->maxDiff = $maxDiff;
        return $this;
    }
}
