<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Mark
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\MarkRepository")
 * @ORM\Table(name="mark", schema="adonis")
 */
class Mark extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $text;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $value;

    /**
     * @var Scale
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\Scale", inversedBy="marks")
     * @ORM\JoinColumn(nullable=false)
     */
    private $scale;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $imageName;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $image;

    /**
     * @return string|null
     */
    public function getImageData()
    {
        if (isset($this->imageName)) {
            return 'data:image/jpeg;base64, ' . base64_encode(file_get_contents($this->imageName));
        }
        if (isset($this->image)) {
            return $this->image;
        }
        return null;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return Mark
     */
    public function setText(string $text): Mark
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    /**
     * @param int $value
     * @return Mark
     */
    public function setValue(int $value): Mark
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return Scale
     */
    public function getScale(): Scale
    {
        return $this->scale;
    }

    /**
     * @param Scale $scale
     * @return Mark
     */
    public function setScale(Scale $scale): Mark
    {
        $this->scale = $scale;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImageName(): ?string
    {
        return $this->imageName;
    }

    /**
     * @param string|null $imageName
     * @return Mark
     */
    public function setImageName(?string $imageName): Mark
    {
        $this->imageName = $imageName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return Mark
     */
    public function setImage(?string $image): Mark
    {
        $this->image = $image;
        return $this;
    }
}
