<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Mobile\Project\Entity\DataEntryProject;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Enumeration\PathLevelEnum;

/**
 * Class StateCode.
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\StateCodeRepository")
 * @ORM\Table(name="state_code", schema="adonis")
 *
 * @psalm-import-type PathLevelEnumId from PathLevelEnum
 */
class StateCode extends IdentifiedEntity
{
    public const NON_PERMANENT_STATE_CODE = 'non_permanent';
    public const DEAD_STATE_CODE = 'dead';
    public const MISSING_STATE_CODE = 'missing';

    /**
     * @var DataEntryProject
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="stateCodes")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $project;

    /**
     * @var integer
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="integer", nullable=false)
     */
    private $code;

    /**
     * @var string
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="string", nullable=false)
     */
    private $label;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $description;

    /**
     * @var string | null
     * @psalm-var PathLevelEnumId|''
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $propagation;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $color;

    /**
     * @var string
     *
     * Field added in order to handle if a state code is permanent or not. If permanent, it define the type.
     *
     * @ORM\Column(type="string", nullable=false, options={"default"="non_permanent"})
     */
    private $type;

    /**
     * @return DataEntryProject
     */
    public function getProject(): DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject $project
     * @return StateCode
     */
    public function setProject(DataEntryProject $project): StateCode
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return StateCode
     */
    public function setCode(int $code): StateCode
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return $this->label;
    }

    /**
     * @param string $label
     * @return StateCode
     */
    public function setLabel(string $label): StateCode
    {
        $this->label = $label;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return StateCode
     */
    public function setDescription(?string $description): StateCode
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return string|null
     * @psalm-return PathLevelEnumId|''
     */
    public function getPropagation(): ?string
    {
        return $this->propagation;
    }

    /**
     * @param string|null $propagation
     * @psalm-param PathLevelEnumId|'' $propagation
     * @return StateCode
     */
    public function setPropagation(?string $propagation): StateCode
    {
        $this->propagation = $propagation;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getColor(): ?string
    {
        return $this->color;
    }

    /**
     * @param string|null $color
     * @return StateCode
     */
    public function setColor(?string $color): StateCode
    {
        $this->color = $color;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return StateCode
     */
    public function setType(string $type): StateCode
    {
        $this->type = $type;
        return $this;
    }
}
