<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class ValueHint.
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\ValueHintRepository")
 * @ORM\Table(name="value_hint", schema="adonis")
 */
class ValueHint extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $value;

    /**
     * @var ValueHintList
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\ValueHintList", inversedBy="valueHints")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $list;

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return ValueHint
     */
    public function setValue(string $value): ValueHint
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return ValueHintList
     */
    public function getList(): ValueHintList
    {
        return $this->list;
    }

    /**
     * @param ValueHintList $list
     */
    public function setList(ValueHintList $list): void
    {
        $this->list = $list;
    }
}
